/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetLogRequest
extends BmcRequest<Void> {
    private String logGroupId;
    private String logId;
    private String opcRequestId;

    @ConstructorProperties(value={"logGroupId", "logId", "opcRequestId"})
    GetLogRequest(String logGroupId, String logId, String opcRequestId) {
        this.logGroupId = logGroupId;
        this.logId = logId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public String getLogId() {
        return this.logId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogRequest, Void> {
        private String logGroupId;
        private String logId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.logId(o.getLogId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogRequest build() {
            GetLogRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder logId(String logId) {
            this.logId = logId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetLogRequest buildWithoutInvocationCallback() {
            return new GetLogRequest(this.logGroupId, this.logId, this.opcRequestId);
        }

        public String toString() {
            return "GetLogRequest.Builder(logGroupId=" + this.logGroupId + ", logId=" + this.logId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

