/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.logging.model.ResourceType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ServiceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="servicePrincipalName")
    private final String servicePrincipalName;
    @JsonProperty(value="endpoint")
    private final String endpoint;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resourceTypes")
    private final List<ResourceType> resourceTypes;

    @Deprecated
    @ConstructorProperties(value={"tenantId", "namespace", "servicePrincipalName", "endpoint", "name", "id", "resourceTypes"})
    public ServiceSummary(String tenantId, String namespace, String servicePrincipalName, String endpoint, String name, String id, List<ResourceType> resourceTypes) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.servicePrincipalName = servicePrincipalName;
        this.endpoint = endpoint;
        this.name = name;
        this.id = id;
        this.resourceTypes = resourceTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<ResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", servicePrincipalName=").append(String.valueOf(this.servicePrincipalName));
        sb.append(", endpoint=").append(String.valueOf(this.endpoint));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", resourceTypes=").append(String.valueOf(this.resourceTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary)((Object)o);
        return Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.servicePrincipalName, other.servicePrincipalName) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.resourceTypes, other.resourceTypes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.servicePrincipalName == null ? 43 : this.servicePrincipalName.hashCode());
        result = result * 59 + (this.endpoint == null ? 43 : this.endpoint.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceTypes == null ? 43 : this.resourceTypes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="servicePrincipalName")
        private String servicePrincipalName;
        @JsonProperty(value="endpoint")
        private String endpoint;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resourceTypes")
        private List<ResourceType> resourceTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            this.__explicitlySet__.add("servicePrincipalName");
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            this.__explicitlySet__.add("endpoint");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceTypes(List<ResourceType> resourceTypes) {
            this.resourceTypes = resourceTypes;
            this.__explicitlySet__.add("resourceTypes");
            return this;
        }

        public ServiceSummary build() {
            ServiceSummary model = new ServiceSummary(this.tenantId, this.namespace, this.servicePrincipalName, this.endpoint, this.name, this.id, this.resourceTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ServiceSummary model) {
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("servicePrincipalName")) {
                this.servicePrincipalName(model.getServicePrincipalName());
            }
            if (model.wasPropertyExplicitlySet("endpoint")) {
                this.endpoint(model.getEndpoint());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceTypes")) {
                this.resourceTypes(model.getResourceTypes());
            }
            return this;
        }
    }
}

