/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.UnifiedAgentMonitoringFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="filterType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentKubernetesFilter
extends UnifiedAgentMonitoringFilter {
    @JsonProperty(value="allowList")
    private final List<String> allowList;
    @JsonProperty(value="denyList")
    private final List<String> denyList;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentKubernetesFilter(String name, List<String> allowList, List<String> denyList) {
        super(name);
        this.allowList = allowList;
        this.denyList = denyList;
    }

    public List<String> getAllowList() {
        return this.allowList;
    }

    public List<String> getDenyList() {
        return this.denyList;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentKubernetesFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", allowList=").append(String.valueOf(this.allowList));
        sb.append(", denyList=").append(String.valueOf(this.denyList));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentKubernetesFilter)) {
            return false;
        }
        UnifiedAgentKubernetesFilter other = (UnifiedAgentKubernetesFilter)((Object)o);
        return Objects.equals(this.allowList, other.allowList) && Objects.equals(this.denyList, other.denyList) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.allowList == null ? 43 : this.allowList.hashCode());
        result = result * 59 + (this.denyList == null ? 43 : this.denyList.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="allowList")
        private List<String> allowList;
        @JsonProperty(value="denyList")
        private List<String> denyList;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder allowList(List<String> allowList) {
            this.allowList = allowList;
            this.__explicitlySet__.add("allowList");
            return this;
        }

        public Builder denyList(List<String> denyList) {
            this.denyList = denyList;
            this.__explicitlySet__.add("denyList");
            return this;
        }

        public UnifiedAgentKubernetesFilter build() {
            UnifiedAgentKubernetesFilter model = new UnifiedAgentKubernetesFilter(this.name, this.allowList, this.denyList);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentKubernetesFilter model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("allowList")) {
                this.allowList(model.getAllowList());
            }
            if (model.wasPropertyExplicitlySet("denyList")) {
                this.denyList(model.getDenyList());
            }
            return this;
        }
    }
}

