/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.GrepFilterAllowRule;
import com.oracle.bmc.logging.model.GrepFilterDenyRule;
import com.oracle.bmc.logging.model.UnifiedAgentLoggingFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="filterType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentLoggingGrepFilter
extends UnifiedAgentLoggingFilter {
    @JsonProperty(value="allowList")
    private final List<GrepFilterAllowRule> allowList;
    @JsonProperty(value="denyList")
    private final List<GrepFilterDenyRule> denyList;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentLoggingGrepFilter(String name, List<GrepFilterAllowRule> allowList, List<GrepFilterDenyRule> denyList) {
        super(name);
        this.allowList = allowList;
        this.denyList = denyList;
    }

    public List<GrepFilterAllowRule> getAllowList() {
        return this.allowList;
    }

    public List<GrepFilterDenyRule> getDenyList() {
        return this.denyList;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentLoggingGrepFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", allowList=").append(String.valueOf(this.allowList));
        sb.append(", denyList=").append(String.valueOf(this.denyList));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentLoggingGrepFilter)) {
            return false;
        }
        UnifiedAgentLoggingGrepFilter other = (UnifiedAgentLoggingGrepFilter)((Object)o);
        return Objects.equals(this.allowList, other.allowList) && Objects.equals(this.denyList, other.denyList) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.allowList == null ? 43 : this.allowList.hashCode());
        result = result * 59 + (this.denyList == null ? 43 : this.denyList.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="allowList")
        private List<GrepFilterAllowRule> allowList;
        @JsonProperty(value="denyList")
        private List<GrepFilterDenyRule> denyList;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder allowList(List<GrepFilterAllowRule> allowList) {
            this.allowList = allowList;
            this.__explicitlySet__.add("allowList");
            return this;
        }

        public Builder denyList(List<GrepFilterDenyRule> denyList) {
            this.denyList = denyList;
            this.__explicitlySet__.add("denyList");
            return this;
        }

        public UnifiedAgentLoggingGrepFilter build() {
            UnifiedAgentLoggingGrepFilter model = new UnifiedAgentLoggingGrepFilter(this.name, this.allowList, this.denyList);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentLoggingGrepFilter model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("allowList")) {
                this.allowList(model.getAllowList());
            }
            if (model.wasPropertyExplicitlySet("denyList")) {
                this.denyList(model.getDenyList());
            }
            return this;
        }
    }
}

