/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.logging.model.UnifiedAgentCustomPluginLogSource;
import com.oracle.bmc.logging.model.UnifiedAgentTailLogSource;
import com.oracle.bmc.logging.model.UnifiedAgentWindowsEventSource;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType", defaultImpl=UnifiedAgentLoggingSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UnifiedAgentCustomPluginLogSource.class, name="CUSTOM_PLUGIN"), @JsonSubTypes.Type(value=UnifiedAgentWindowsEventSource.class, name="WINDOWS_EVENT_LOG"), @JsonSubTypes.Type(value=UnifiedAgentTailLogSource.class, name="LOG_TAIL")})
@JsonFilter(value="explicitlySetFilter")
public class UnifiedAgentLoggingSource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;

    @Deprecated
    @ConstructorProperties(value={"name"})
    protected UnifiedAgentLoggingSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentLoggingSource(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentLoggingSource)) {
            return false;
        }
        UnifiedAgentLoggingSource other = (UnifiedAgentLoggingSource)((Object)o);
        return Objects.equals(this.name, other.name) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SourceType implements BmcEnum
    {
        LogTail("LOG_TAIL"),
        WindowsEventLog("WINDOWS_EVENT_LOG"),
        CustomPlugin("CUSTOM_PLUGIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SourceType> map;

        private SourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SourceType.class);
            map = new HashMap<String, SourceType>();
            for (SourceType v : SourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

