/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.logging.model.UnifiedAgentApache2Parser;
import com.oracle.bmc.logging.model.UnifiedAgentApacheErrorParser;
import com.oracle.bmc.logging.model.UnifiedAgentAuditdParser;
import com.oracle.bmc.logging.model.UnifiedAgentCriParser;
import com.oracle.bmc.logging.model.UnifiedAgentCsvParser;
import com.oracle.bmc.logging.model.UnifiedAgentGrokParser;
import com.oracle.bmc.logging.model.UnifiedAgentMsgpackParser;
import com.oracle.bmc.logging.model.UnifiedAgentMultilineGrokParser;
import com.oracle.bmc.logging.model.UnifiedAgentMultilineParser;
import com.oracle.bmc.logging.model.UnifiedAgentNoneParser;
import com.oracle.bmc.logging.model.UnifiedAgentOpenmetricsParser;
import com.oracle.bmc.logging.model.UnifiedAgentRegexParser;
import com.oracle.bmc.logging.model.UnifiedAgentSyslogParser;
import com.oracle.bmc.logging.model.UnifiedAgentTsvParser;
import com.oracle.bmc.logging.model.UnifiedJSONParser;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="parserType", defaultImpl=UnifiedAgentParser.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UnifiedAgentMultilineGrokParser.class, name="MULTILINE_GROK"), @JsonSubTypes.Type(value=UnifiedJSONParser.class, name="JSON"), @JsonSubTypes.Type(value=UnifiedAgentGrokParser.class, name="GROK"), @JsonSubTypes.Type(value=UnifiedAgentNoneParser.class, name="NONE"), @JsonSubTypes.Type(value=UnifiedAgentSyslogParser.class, name="SYSLOG"), @JsonSubTypes.Type(value=UnifiedAgentOpenmetricsParser.class, name="OPENMETRICS"), @JsonSubTypes.Type(value=UnifiedAgentAuditdParser.class, name="AUDITD"), @JsonSubTypes.Type(value=UnifiedAgentApache2Parser.class, name="APACHE2"), @JsonSubTypes.Type(value=UnifiedAgentRegexParser.class, name="REGEXP"), @JsonSubTypes.Type(value=UnifiedAgentMultilineParser.class, name="MULTILINE"), @JsonSubTypes.Type(value=UnifiedAgentTsvParser.class, name="TSV"), @JsonSubTypes.Type(value=UnifiedAgentCriParser.class, name="CRI"), @JsonSubTypes.Type(value=UnifiedAgentApacheErrorParser.class, name="APACHE_ERROR"), @JsonSubTypes.Type(value=UnifiedAgentMsgpackParser.class, name="MSGPACK"), @JsonSubTypes.Type(value=UnifiedAgentCsvParser.class, name="CSV")})
@JsonFilter(value="explicitlySetFilter")
public class UnifiedAgentParser
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fieldTimeKey")
    private final String fieldTimeKey;
    @JsonProperty(value="types")
    private final Map<String, String> types;
    @JsonProperty(value="nullValuePattern")
    private final String nullValuePattern;
    @JsonProperty(value="isNullEmptyString")
    private final Boolean isNullEmptyString;
    @JsonProperty(value="isEstimateCurrentEvent")
    private final Boolean isEstimateCurrentEvent;
    @JsonProperty(value="isKeepTimeKey")
    private final Boolean isKeepTimeKey;
    @JsonProperty(value="timeoutInMilliseconds")
    private final Integer timeoutInMilliseconds;

    @Deprecated
    @ConstructorProperties(value={"fieldTimeKey", "types", "nullValuePattern", "isNullEmptyString", "isEstimateCurrentEvent", "isKeepTimeKey", "timeoutInMilliseconds"})
    protected UnifiedAgentParser(String fieldTimeKey, Map<String, String> types, String nullValuePattern, Boolean isNullEmptyString, Boolean isEstimateCurrentEvent, Boolean isKeepTimeKey, Integer timeoutInMilliseconds) {
        this.fieldTimeKey = fieldTimeKey;
        this.types = types;
        this.nullValuePattern = nullValuePattern;
        this.isNullEmptyString = isNullEmptyString;
        this.isEstimateCurrentEvent = isEstimateCurrentEvent;
        this.isKeepTimeKey = isKeepTimeKey;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public String getFieldTimeKey() {
        return this.fieldTimeKey;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public String getNullValuePattern() {
        return this.nullValuePattern;
    }

    public Boolean getIsNullEmptyString() {
        return this.isNullEmptyString;
    }

    public Boolean getIsEstimateCurrentEvent() {
        return this.isEstimateCurrentEvent;
    }

    public Boolean getIsKeepTimeKey() {
        return this.isKeepTimeKey;
    }

    public Integer getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentParser(");
        sb.append("super=").append(super.toString());
        sb.append("fieldTimeKey=").append(String.valueOf(this.fieldTimeKey));
        sb.append(", types=").append(String.valueOf(this.types));
        sb.append(", nullValuePattern=").append(String.valueOf(this.nullValuePattern));
        sb.append(", isNullEmptyString=").append(String.valueOf(this.isNullEmptyString));
        sb.append(", isEstimateCurrentEvent=").append(String.valueOf(this.isEstimateCurrentEvent));
        sb.append(", isKeepTimeKey=").append(String.valueOf(this.isKeepTimeKey));
        sb.append(", timeoutInMilliseconds=").append(String.valueOf(this.timeoutInMilliseconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentParser)) {
            return false;
        }
        UnifiedAgentParser other = (UnifiedAgentParser)((Object)o);
        return Objects.equals(this.fieldTimeKey, other.fieldTimeKey) && Objects.equals(this.types, other.types) && Objects.equals(this.nullValuePattern, other.nullValuePattern) && Objects.equals(this.isNullEmptyString, other.isNullEmptyString) && Objects.equals(this.isEstimateCurrentEvent, other.isEstimateCurrentEvent) && Objects.equals(this.isKeepTimeKey, other.isKeepTimeKey) && Objects.equals(this.timeoutInMilliseconds, other.timeoutInMilliseconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fieldTimeKey == null ? 43 : this.fieldTimeKey.hashCode());
        result = result * 59 + (this.types == null ? 43 : this.types.hashCode());
        result = result * 59 + (this.nullValuePattern == null ? 43 : this.nullValuePattern.hashCode());
        result = result * 59 + (this.isNullEmptyString == null ? 43 : this.isNullEmptyString.hashCode());
        result = result * 59 + (this.isEstimateCurrentEvent == null ? 43 : this.isEstimateCurrentEvent.hashCode());
        result = result * 59 + (this.isKeepTimeKey == null ? 43 : this.isKeepTimeKey.hashCode());
        result = result * 59 + (this.timeoutInMilliseconds == null ? 43 : this.timeoutInMilliseconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ParserType implements BmcEnum
    {
        Auditd("AUDITD"),
        Cri("CRI"),
        Json("JSON"),
        Tsv("TSV"),
        Csv("CSV"),
        None("NONE"),
        Syslog("SYSLOG"),
        Apache2("APACHE2"),
        ApacheError("APACHE_ERROR"),
        Msgpack("MSGPACK"),
        Regexp("REGEXP"),
        Multiline("MULTILINE"),
        Grok("GROK"),
        MultilineGrok("MULTILINE_GROK"),
        Openmetrics("OPENMETRICS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ParserType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ParserType.class);
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

