/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.UnifiedAgentLoggingFilter;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="filterType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentParserFilter
extends UnifiedAgentLoggingFilter {
    @JsonProperty(value="parser")
    private final UnifiedAgentParser parser;
    @JsonProperty(value="keyName")
    private final String keyName;
    @JsonProperty(value="reserveTime")
    private final Boolean reserveTime;
    @JsonProperty(value="reserveData")
    private final Boolean reserveData;
    @JsonProperty(value="removeKeyNameField")
    private final Boolean removeKeyNameField;
    @JsonProperty(value="replaceInvalidSequence")
    private final Boolean replaceInvalidSequence;
    @JsonProperty(value="injectKeyPrefix")
    private final String injectKeyPrefix;
    @JsonProperty(value="hashValueField")
    private final String hashValueField;
    @JsonProperty(value="emitInvalidRecordToError")
    private final Boolean emitInvalidRecordToError;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentParserFilter(String name, UnifiedAgentParser parser, String keyName, Boolean reserveTime, Boolean reserveData, Boolean removeKeyNameField, Boolean replaceInvalidSequence, String injectKeyPrefix, String hashValueField, Boolean emitInvalidRecordToError) {
        super(name);
        this.parser = parser;
        this.keyName = keyName;
        this.reserveTime = reserveTime;
        this.reserveData = reserveData;
        this.removeKeyNameField = removeKeyNameField;
        this.replaceInvalidSequence = replaceInvalidSequence;
        this.injectKeyPrefix = injectKeyPrefix;
        this.hashValueField = hashValueField;
        this.emitInvalidRecordToError = emitInvalidRecordToError;
    }

    public UnifiedAgentParser getParser() {
        return this.parser;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Boolean getReserveTime() {
        return this.reserveTime;
    }

    public Boolean getReserveData() {
        return this.reserveData;
    }

    public Boolean getRemoveKeyNameField() {
        return this.removeKeyNameField;
    }

    public Boolean getReplaceInvalidSequence() {
        return this.replaceInvalidSequence;
    }

    public String getInjectKeyPrefix() {
        return this.injectKeyPrefix;
    }

    public String getHashValueField() {
        return this.hashValueField;
    }

    public Boolean getEmitInvalidRecordToError() {
        return this.emitInvalidRecordToError;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentParserFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", parser=").append(String.valueOf((Object)this.parser));
        sb.append(", keyName=").append(String.valueOf(this.keyName));
        sb.append(", reserveTime=").append(String.valueOf(this.reserveTime));
        sb.append(", reserveData=").append(String.valueOf(this.reserveData));
        sb.append(", removeKeyNameField=").append(String.valueOf(this.removeKeyNameField));
        sb.append(", replaceInvalidSequence=").append(String.valueOf(this.replaceInvalidSequence));
        sb.append(", injectKeyPrefix=").append(String.valueOf(this.injectKeyPrefix));
        sb.append(", hashValueField=").append(String.valueOf(this.hashValueField));
        sb.append(", emitInvalidRecordToError=").append(String.valueOf(this.emitInvalidRecordToError));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentParserFilter)) {
            return false;
        }
        UnifiedAgentParserFilter other = (UnifiedAgentParserFilter)((Object)o);
        return Objects.equals((Object)this.parser, (Object)other.parser) && Objects.equals(this.keyName, other.keyName) && Objects.equals(this.reserveTime, other.reserveTime) && Objects.equals(this.reserveData, other.reserveData) && Objects.equals(this.removeKeyNameField, other.removeKeyNameField) && Objects.equals(this.replaceInvalidSequence, other.replaceInvalidSequence) && Objects.equals(this.injectKeyPrefix, other.injectKeyPrefix) && Objects.equals(this.hashValueField, other.hashValueField) && Objects.equals(this.emitInvalidRecordToError, other.emitInvalidRecordToError) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.parser == null ? 43 : this.parser.hashCode());
        result = result * 59 + (this.keyName == null ? 43 : this.keyName.hashCode());
        result = result * 59 + (this.reserveTime == null ? 43 : this.reserveTime.hashCode());
        result = result * 59 + (this.reserveData == null ? 43 : this.reserveData.hashCode());
        result = result * 59 + (this.removeKeyNameField == null ? 43 : this.removeKeyNameField.hashCode());
        result = result * 59 + (this.replaceInvalidSequence == null ? 43 : this.replaceInvalidSequence.hashCode());
        result = result * 59 + (this.injectKeyPrefix == null ? 43 : this.injectKeyPrefix.hashCode());
        result = result * 59 + (this.hashValueField == null ? 43 : this.hashValueField.hashCode());
        result = result * 59 + (this.emitInvalidRecordToError == null ? 43 : this.emitInvalidRecordToError.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="parser")
        private UnifiedAgentParser parser;
        @JsonProperty(value="keyName")
        private String keyName;
        @JsonProperty(value="reserveTime")
        private Boolean reserveTime;
        @JsonProperty(value="reserveData")
        private Boolean reserveData;
        @JsonProperty(value="removeKeyNameField")
        private Boolean removeKeyNameField;
        @JsonProperty(value="replaceInvalidSequence")
        private Boolean replaceInvalidSequence;
        @JsonProperty(value="injectKeyPrefix")
        private String injectKeyPrefix;
        @JsonProperty(value="hashValueField")
        private String hashValueField;
        @JsonProperty(value="emitInvalidRecordToError")
        private Boolean emitInvalidRecordToError;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder parser(UnifiedAgentParser parser) {
            this.parser = parser;
            this.__explicitlySet__.add("parser");
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            this.__explicitlySet__.add("keyName");
            return this;
        }

        public Builder reserveTime(Boolean reserveTime) {
            this.reserveTime = reserveTime;
            this.__explicitlySet__.add("reserveTime");
            return this;
        }

        public Builder reserveData(Boolean reserveData) {
            this.reserveData = reserveData;
            this.__explicitlySet__.add("reserveData");
            return this;
        }

        public Builder removeKeyNameField(Boolean removeKeyNameField) {
            this.removeKeyNameField = removeKeyNameField;
            this.__explicitlySet__.add("removeKeyNameField");
            return this;
        }

        public Builder replaceInvalidSequence(Boolean replaceInvalidSequence) {
            this.replaceInvalidSequence = replaceInvalidSequence;
            this.__explicitlySet__.add("replaceInvalidSequence");
            return this;
        }

        public Builder injectKeyPrefix(String injectKeyPrefix) {
            this.injectKeyPrefix = injectKeyPrefix;
            this.__explicitlySet__.add("injectKeyPrefix");
            return this;
        }

        public Builder hashValueField(String hashValueField) {
            this.hashValueField = hashValueField;
            this.__explicitlySet__.add("hashValueField");
            return this;
        }

        public Builder emitInvalidRecordToError(Boolean emitInvalidRecordToError) {
            this.emitInvalidRecordToError = emitInvalidRecordToError;
            this.__explicitlySet__.add("emitInvalidRecordToError");
            return this;
        }

        public UnifiedAgentParserFilter build() {
            UnifiedAgentParserFilter model = new UnifiedAgentParserFilter(this.name, this.parser, this.keyName, this.reserveTime, this.reserveData, this.removeKeyNameField, this.replaceInvalidSequence, this.injectKeyPrefix, this.hashValueField, this.emitInvalidRecordToError);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentParserFilter model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("parser")) {
                this.parser(model.getParser());
            }
            if (model.wasPropertyExplicitlySet("keyName")) {
                this.keyName(model.getKeyName());
            }
            if (model.wasPropertyExplicitlySet("reserveTime")) {
                this.reserveTime(model.getReserveTime());
            }
            if (model.wasPropertyExplicitlySet("reserveData")) {
                this.reserveData(model.getReserveData());
            }
            if (model.wasPropertyExplicitlySet("removeKeyNameField")) {
                this.removeKeyNameField(model.getRemoveKeyNameField());
            }
            if (model.wasPropertyExplicitlySet("replaceInvalidSequence")) {
                this.replaceInvalidSequence(model.getReplaceInvalidSequence());
            }
            if (model.wasPropertyExplicitlySet("injectKeyPrefix")) {
                this.injectKeyPrefix(model.getInjectKeyPrefix());
            }
            if (model.wasPropertyExplicitlySet("hashValueField")) {
                this.hashValueField(model.getHashValueField());
            }
            if (model.wasPropertyExplicitlySet("emitInvalidRecordToError")) {
                this.emitInvalidRecordToError(model.getEmitInvalidRecordToError());
            }
            return this;
        }
    }
}

