/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="parserType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedJSONParser
extends UnifiedAgentParser {
    @JsonProperty(value="timeType")
    private final TimeType timeType;
    @JsonProperty(value="timeFormat")
    private final String timeFormat;
    @JsonProperty(value="parseNested")
    private final Boolean parseNested;
    @JsonProperty(value="separator")
    private final String separator;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedJSONParser(String fieldTimeKey, Map<String, String> types, String nullValuePattern, Boolean isNullEmptyString, Boolean isEstimateCurrentEvent, Boolean isKeepTimeKey, Integer timeoutInMilliseconds, TimeType timeType, String timeFormat, Boolean parseNested, String separator) {
        super(fieldTimeKey, types, nullValuePattern, isNullEmptyString, isEstimateCurrentEvent, isKeepTimeKey, timeoutInMilliseconds);
        this.timeType = timeType;
        this.timeFormat = timeFormat;
        this.parseNested = parseNested;
        this.separator = separator;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public Boolean getParseNested() {
        return this.parseNested;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedJSONParser(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", timeType=").append(String.valueOf((Object)this.timeType));
        sb.append(", timeFormat=").append(String.valueOf(this.timeFormat));
        sb.append(", parseNested=").append(String.valueOf(this.parseNested));
        sb.append(", separator=").append(String.valueOf(this.separator));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedJSONParser)) {
            return false;
        }
        UnifiedJSONParser other = (UnifiedJSONParser)((Object)o);
        return Objects.equals((Object)this.timeType, (Object)other.timeType) && Objects.equals(this.timeFormat, other.timeFormat) && Objects.equals(this.parseNested, other.parseNested) && Objects.equals(this.separator, other.separator) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.timeType == null ? 43 : this.timeType.hashCode());
        result = result * 59 + (this.timeFormat == null ? 43 : this.timeFormat.hashCode());
        result = result * 59 + (this.parseNested == null ? 43 : this.parseNested.hashCode());
        result = result * 59 + (this.separator == null ? 43 : this.separator.hashCode());
        return result;
    }

    public static enum TimeType implements BmcEnum
    {
        Float("FLOAT"),
        Unixtime("UNIXTIME"),
        String("STRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TimeType> map;

        private TimeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TimeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TimeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TimeType.class);
            map = new HashMap<String, TimeType>();
            for (TimeType v : TimeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldTimeKey")
        private String fieldTimeKey;
        @JsonProperty(value="types")
        private Map<String, String> types;
        @JsonProperty(value="nullValuePattern")
        private String nullValuePattern;
        @JsonProperty(value="isNullEmptyString")
        private Boolean isNullEmptyString;
        @JsonProperty(value="isEstimateCurrentEvent")
        private Boolean isEstimateCurrentEvent;
        @JsonProperty(value="isKeepTimeKey")
        private Boolean isKeepTimeKey;
        @JsonProperty(value="timeoutInMilliseconds")
        private Integer timeoutInMilliseconds;
        @JsonProperty(value="timeType")
        private TimeType timeType;
        @JsonProperty(value="timeFormat")
        private String timeFormat;
        @JsonProperty(value="parseNested")
        private Boolean parseNested;
        @JsonProperty(value="separator")
        private String separator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldTimeKey(String fieldTimeKey) {
            this.fieldTimeKey = fieldTimeKey;
            this.__explicitlySet__.add("fieldTimeKey");
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types = types;
            this.__explicitlySet__.add("types");
            return this;
        }

        public Builder nullValuePattern(String nullValuePattern) {
            this.nullValuePattern = nullValuePattern;
            this.__explicitlySet__.add("nullValuePattern");
            return this;
        }

        public Builder isNullEmptyString(Boolean isNullEmptyString) {
            this.isNullEmptyString = isNullEmptyString;
            this.__explicitlySet__.add("isNullEmptyString");
            return this;
        }

        public Builder isEstimateCurrentEvent(Boolean isEstimateCurrentEvent) {
            this.isEstimateCurrentEvent = isEstimateCurrentEvent;
            this.__explicitlySet__.add("isEstimateCurrentEvent");
            return this;
        }

        public Builder isKeepTimeKey(Boolean isKeepTimeKey) {
            this.isKeepTimeKey = isKeepTimeKey;
            this.__explicitlySet__.add("isKeepTimeKey");
            return this;
        }

        public Builder timeoutInMilliseconds(Integer timeoutInMilliseconds) {
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.__explicitlySet__.add("timeoutInMilliseconds");
            return this;
        }

        public Builder timeType(TimeType timeType) {
            this.timeType = timeType;
            this.__explicitlySet__.add("timeType");
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            this.__explicitlySet__.add("timeFormat");
            return this;
        }

        public Builder parseNested(Boolean parseNested) {
            this.parseNested = parseNested;
            this.__explicitlySet__.add("parseNested");
            return this;
        }

        public Builder separator(String separator) {
            this.separator = separator;
            this.__explicitlySet__.add("separator");
            return this;
        }

        public UnifiedJSONParser build() {
            UnifiedJSONParser model = new UnifiedJSONParser(this.fieldTimeKey, this.types, this.nullValuePattern, this.isNullEmptyString, this.isEstimateCurrentEvent, this.isKeepTimeKey, this.timeoutInMilliseconds, this.timeType, this.timeFormat, this.parseNested, this.separator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedJSONParser model) {
            if (model.wasPropertyExplicitlySet("fieldTimeKey")) {
                this.fieldTimeKey(model.getFieldTimeKey());
            }
            if (model.wasPropertyExplicitlySet("types")) {
                this.types(model.getTypes());
            }
            if (model.wasPropertyExplicitlySet("nullValuePattern")) {
                this.nullValuePattern(model.getNullValuePattern());
            }
            if (model.wasPropertyExplicitlySet("isNullEmptyString")) {
                this.isNullEmptyString(model.getIsNullEmptyString());
            }
            if (model.wasPropertyExplicitlySet("isEstimateCurrentEvent")) {
                this.isEstimateCurrentEvent(model.getIsEstimateCurrentEvent());
            }
            if (model.wasPropertyExplicitlySet("isKeepTimeKey")) {
                this.isKeepTimeKey(model.getIsKeepTimeKey());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMilliseconds")) {
                this.timeoutInMilliseconds(model.getTimeoutInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("timeType")) {
                this.timeType(model.getTimeType());
            }
            if (model.wasPropertyExplicitlySet("timeFormat")) {
                this.timeFormat(model.getTimeFormat());
            }
            if (model.wasPropertyExplicitlySet("parseNested")) {
                this.parseNested(model.getParseNested());
            }
            if (model.wasPropertyExplicitlySet("separator")) {
                this.separator(model.getSeparator());
            }
            return this;
        }
    }
}

