/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.logging.model.UpdateLogDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateLogRequest
extends BmcRequest<UpdateLogDetails> {
    private String logGroupId;
    private String logId;
    private UpdateLogDetails updateLogDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public String getLogId() {
        return this.logId;
    }

    public UpdateLogDetails getUpdateLogDetails() {
        return this.updateLogDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateLogDetails getBody$() {
        return this.updateLogDetails;
    }

    public Builder toBuilder() {
        return new Builder().logGroupId(this.logGroupId).logId(this.logId).updateLogDetails(this.updateLogDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(",logId=").append(String.valueOf(this.logId));
        sb.append(",updateLogDetails=").append(String.valueOf((Object)this.updateLogDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateLogRequest)) {
            return false;
        }
        UpdateLogRequest other = (UpdateLogRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals(this.logId, other.logId) && Objects.equals((Object)this.updateLogDetails, (Object)other.updateLogDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.logId == null ? 43 : this.logId.hashCode());
        result = result * 59 + (this.updateLogDetails == null ? 43 : this.updateLogDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateLogRequest, UpdateLogDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String logGroupId = null;
        private String logId = null;
        private UpdateLogDetails updateLogDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder logId(String logId) {
            this.logId = logId;
            return this;
        }

        public Builder updateLogDetails(UpdateLogDetails updateLogDetails) {
            this.updateLogDetails = updateLogDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateLogRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.logId(o.getLogId());
            this.updateLogDetails(o.getUpdateLogDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateLogRequest build() {
            UpdateLogRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateLogDetails body) {
            this.updateLogDetails(body);
            return this;
        }

        public UpdateLogRequest buildWithoutInvocationCallback() {
            UpdateLogRequest request = new UpdateLogRequest();
            request.logGroupId = this.logGroupId;
            request.logId = this.logId;
            request.updateLogDetails = this.updateLogDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

