/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.logging.LoggingManagementAsync;
import com.oracle.bmc.logging.model.Log;
import com.oracle.bmc.logging.model.LogGroup;
import com.oracle.bmc.logging.model.LogGroupSummary;
import com.oracle.bmc.logging.model.LogSavedSearch;
import com.oracle.bmc.logging.model.LogSavedSearchSummaryCollection;
import com.oracle.bmc.logging.model.LogSummary;
import com.oracle.bmc.logging.model.ServiceSummary;
import com.oracle.bmc.logging.model.UnifiedAgentConfiguration;
import com.oracle.bmc.logging.model.UnifiedAgentConfigurationCollection;
import com.oracle.bmc.logging.model.WorkRequest;
import com.oracle.bmc.logging.model.WorkRequestError;
import com.oracle.bmc.logging.model.WorkRequestLog;
import com.oracle.bmc.logging.model.WorkRequestSummary;
import com.oracle.bmc.logging.requests.ChangeLogGroupCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeLogLogGroupRequest;
import com.oracle.bmc.logging.requests.ChangeLogSavedSearchCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeUnifiedAgentConfigurationCompartmentRequest;
import com.oracle.bmc.logging.requests.CreateLogGroupRequest;
import com.oracle.bmc.logging.requests.CreateLogRequest;
import com.oracle.bmc.logging.requests.CreateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.CreateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteLogGroupRequest;
import com.oracle.bmc.logging.requests.DeleteLogRequest;
import com.oracle.bmc.logging.requests.DeleteLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.DeleteUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.logging.requests.GetLogGroupRequest;
import com.oracle.bmc.logging.requests.GetLogRequest;
import com.oracle.bmc.logging.requests.GetLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.GetUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.GetWorkRequestRequest;
import com.oracle.bmc.logging.requests.ListLogGroupsRequest;
import com.oracle.bmc.logging.requests.ListLogSavedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogsRequest;
import com.oracle.bmc.logging.requests.ListServicesRequest;
import com.oracle.bmc.logging.requests.ListUnifiedAgentConfigurationsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestsRequest;
import com.oracle.bmc.logging.requests.UpdateLogGroupRequest;
import com.oracle.bmc.logging.requests.UpdateLogRequest;
import com.oracle.bmc.logging.requests.UpdateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.UpdateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.responses.ChangeLogGroupCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeLogLogGroupResponse;
import com.oracle.bmc.logging.responses.ChangeLogSavedSearchCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeUnifiedAgentConfigurationCompartmentResponse;
import com.oracle.bmc.logging.responses.CreateLogGroupResponse;
import com.oracle.bmc.logging.responses.CreateLogResponse;
import com.oracle.bmc.logging.responses.CreateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.CreateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteLogGroupResponse;
import com.oracle.bmc.logging.responses.DeleteLogResponse;
import com.oracle.bmc.logging.responses.DeleteLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.DeleteUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.logging.responses.GetLogGroupResponse;
import com.oracle.bmc.logging.responses.GetLogResponse;
import com.oracle.bmc.logging.responses.GetLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.GetUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.GetWorkRequestResponse;
import com.oracle.bmc.logging.responses.ListLogGroupsResponse;
import com.oracle.bmc.logging.responses.ListLogSavedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogsResponse;
import com.oracle.bmc.logging.responses.ListServicesResponse;
import com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestsResponse;
import com.oracle.bmc.logging.responses.UpdateLogGroupResponse;
import com.oracle.bmc.logging.responses.UpdateLogResponse;
import com.oracle.bmc.logging.responses.UpdateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.UpdateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingManagementAsyncClient
extends BaseAsyncClient
implements LoggingManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGGINGMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://logging.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LoggingManagementAsyncClient.class);

    LoggingManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeLogGroupCompartmentResponse> changeLogGroupCompartment(ChangeLogGroupCompartmentRequest request, AsyncHandler<ChangeLogGroupCompartmentRequest, ChangeLogGroupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogGroupCompartmentDetails(), "changeLogGroupCompartmentDetails is required");
        return this.clientCall(request, ChangeLogGroupCompartmentResponse::builder).logger(LOG, "changeLogGroupCompartment").serviceDetails("LoggingManagement", "ChangeLogGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/ChangeLogGroupCompartment").method(Method.POST).requestBuilder(ChangeLogGroupCompartmentRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeLogGroupCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeLogGroupCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeLogLogGroupResponse> changeLogLogGroup(ChangeLogLogGroupRequest request, AsyncHandler<ChangeLogLogGroupRequest, ChangeLogLogGroupResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogLogGroupDetails(), "changeLogLogGroupDetails is required");
        return this.clientCall(request, ChangeLogLogGroupResponse::builder).logger(LOG, "changeLogLogGroup").serviceDetails("LoggingManagement", "ChangeLogLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/ChangeLogLogGroup").method(Method.POST).requestBuilder(ChangeLogLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).appendPathParam("actions").appendPathParam("changeLogGroup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeLogLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeLogLogGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeLogSavedSearchCompartmentResponse> changeLogSavedSearchCompartment(ChangeLogSavedSearchCompartmentRequest request, AsyncHandler<ChangeLogSavedSearchCompartmentRequest, ChangeLogSavedSearchCompartmentResponse> handler) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogSavedSearchCompartmentDetails(), "changeLogSavedSearchCompartmentDetails is required");
        return this.clientCall(request, ChangeLogSavedSearchCompartmentResponse::builder).logger(LOG, "changeLogSavedSearchCompartment").serviceDetails("LoggingManagement", "ChangeLogSavedSearchCompartment", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/ChangeLogSavedSearchCompartment").method(Method.POST).requestBuilder(ChangeLogSavedSearchCompartmentRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeLogSavedSearchCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeUnifiedAgentConfigurationCompartmentResponse> changeUnifiedAgentConfigurationCompartment(ChangeUnifiedAgentConfigurationCompartmentRequest request, AsyncHandler<ChangeUnifiedAgentConfigurationCompartmentRequest, ChangeUnifiedAgentConfigurationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeUnifiedAgentConfigurationCompartmentDetails(), "changeUnifiedAgentConfigurationCompartmentDetails is required");
        return this.clientCall(request, ChangeUnifiedAgentConfigurationCompartmentResponse::builder).logger(LOG, "changeUnifiedAgentConfigurationCompartment").serviceDetails("LoggingManagement", "ChangeUnifiedAgentConfigurationCompartment", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/ChangeUnifiedAgentConfigurationCompartment").method(Method.POST).requestBuilder(ChangeUnifiedAgentConfigurationCompartmentRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeUnifiedAgentConfigurationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeUnifiedAgentConfigurationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateLogResponse> createLog(CreateLogRequest request, AsyncHandler<CreateLogRequest, CreateLogResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogDetails(), "createLogDetails is required");
        return this.clientCall(request, CreateLogResponse::builder).logger(LOG, "createLog").serviceDetails("LoggingManagement", "CreateLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/CreateLog").method(Method.POST).requestBuilder(CreateLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateLogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLogResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateLogGroupResponse> createLogGroup(CreateLogGroupRequest request, AsyncHandler<CreateLogGroupRequest, CreateLogGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateLogGroupDetails(), "createLogGroupDetails is required");
        return this.clientCall(request, CreateLogGroupResponse::builder).logger(LOG, "createLogGroup").serviceDetails("LoggingManagement", "CreateLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/CreateLogGroup").method(Method.POST).requestBuilder(CreateLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLogGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateLogSavedSearchResponse> createLogSavedSearch(CreateLogSavedSearchRequest request, AsyncHandler<CreateLogSavedSearchRequest, CreateLogSavedSearchResponse> handler) {
        Objects.requireNonNull(request.getCreateLogSavedSearchDetails(), "createLogSavedSearchDetails is required");
        return this.clientCall(request, CreateLogSavedSearchResponse::builder).logger(LOG, "createLogSavedSearch").serviceDetails("LoggingManagement", "CreateLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/CreateLogSavedSearch").method(Method.POST).requestBuilder(CreateLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogSavedSearch.class, CreateLogSavedSearchResponse.Builder::logSavedSearch).handleResponseHeaderString("opc-request-id", CreateLogSavedSearchResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateLogSavedSearchResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateUnifiedAgentConfigurationResponse> createUnifiedAgentConfiguration(CreateUnifiedAgentConfigurationRequest request, AsyncHandler<CreateUnifiedAgentConfigurationRequest, CreateUnifiedAgentConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCreateUnifiedAgentConfigurationDetails(), "createUnifiedAgentConfigurationDetails is required");
        return this.clientCall(request, CreateUnifiedAgentConfigurationResponse::builder).logger(LOG, "createUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "CreateUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/CreateUnifiedAgentConfiguration").method(Method.POST).requestBuilder(CreateUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateUnifiedAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateUnifiedAgentConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteLogResponse> deleteLog(DeleteLogRequest request, AsyncHandler<DeleteLogRequest, DeleteLogResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteLogResponse::builder).logger(LOG, "deleteLog").serviceDetails("LoggingManagement", "DeleteLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/DeleteLog").method(Method.DELETE).requestBuilder(DeleteLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteLogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLogResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteLogGroupResponse> deleteLogGroup(DeleteLogGroupRequest request, AsyncHandler<DeleteLogGroupRequest, DeleteLogGroupResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteLogGroupResponse::builder).logger(LOG, "deleteLogGroup").serviceDetails("LoggingManagement", "DeleteLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/DeleteLogGroup").method(Method.DELETE).requestBuilder(DeleteLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLogGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteLogSavedSearchResponse> deleteLogSavedSearch(DeleteLogSavedSearchRequest request, AsyncHandler<DeleteLogSavedSearchRequest, DeleteLogSavedSearchResponse> handler) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteLogSavedSearchResponse::builder).logger(LOG, "deleteLogSavedSearch").serviceDetails("LoggingManagement", "DeleteLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/DeleteLogSavedSearch").method(Method.DELETE).requestBuilder(DeleteLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLogSavedSearchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteUnifiedAgentConfigurationResponse> deleteUnifiedAgentConfiguration(DeleteUnifiedAgentConfigurationRequest request, AsyncHandler<DeleteUnifiedAgentConfigurationRequest, DeleteUnifiedAgentConfigurationResponse> handler) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteUnifiedAgentConfigurationResponse::builder).logger(LOG, "deleteUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "DeleteUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/DeleteUnifiedAgentConfiguration").method(Method.DELETE).requestBuilder(DeleteUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteUnifiedAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteUnifiedAgentConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("LoggingManagement", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWorkRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetLogResponse> getLog(GetLogRequest request, AsyncHandler<GetLogRequest, GetLogResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLogResponse::builder).logger(LOG, "getLog").serviceDetails("LoggingManagement", "GetLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/GetLog").method(Method.GET).requestBuilder(GetLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Log.class, GetLogResponse.Builder::log).handleResponseHeaderString("opc-request-id", GetLogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetLogResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetLogGroupResponse> getLogGroup(GetLogGroupRequest request, AsyncHandler<GetLogGroupRequest, GetLogGroupResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLogGroupResponse::builder).logger(LOG, "getLogGroup").serviceDetails("LoggingManagement", "GetLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/GetLogGroup").method(Method.GET).requestBuilder(GetLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogGroup.class, GetLogGroupResponse.Builder::logGroup).handleResponseHeaderString("opc-request-id", GetLogGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetLogGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetLogSavedSearchResponse> getLogSavedSearch(GetLogSavedSearchRequest request, AsyncHandler<GetLogSavedSearchRequest, GetLogSavedSearchResponse> handler) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetLogSavedSearchResponse::builder).logger(LOG, "getLogSavedSearch").serviceDetails("LoggingManagement", "GetLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/GetLogSavedSearch").method(Method.GET).requestBuilder(GetLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogSavedSearch.class, GetLogSavedSearchResponse.Builder::logSavedSearch).handleResponseHeaderString("opc-request-id", GetLogSavedSearchResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetLogSavedSearchResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetUnifiedAgentConfigurationResponse> getUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request, AsyncHandler<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> handler) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUnifiedAgentConfigurationResponse::builder).logger(LOG, "getUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "GetUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/GetUnifiedAgentConfiguration").method(Method.GET).requestBuilder(GetUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UnifiedAgentConfiguration.class, GetUnifiedAgentConfigurationResponse.Builder::unifiedAgentConfiguration).handleResponseHeaderString("opc-request-id", GetUnifiedAgentConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetUnifiedAgentConfigurationResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("LoggingManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderBigDecimal("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListLogGroupsResponse> listLogGroups(ListLogGroupsRequest request, AsyncHandler<ListLogGroupsRequest, ListLogGroupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListLogGroupsResponse::builder).logger(LOG, "listLogGroups").serviceDetails("LoggingManagement", "ListLogGroups", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroupSummary/ListLogGroups").method(Method.GET).requestBuilder(ListLogGroupsRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LogGroupSummary.class, ListLogGroupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLogGroupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListLogGroupsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListLogGroupsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLogSavedSearchesResponse> listLogSavedSearches(ListLogSavedSearchesRequest request, AsyncHandler<ListLogSavedSearchesRequest, ListLogSavedSearchesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListLogSavedSearchesResponse::builder).logger(LOG, "listLogSavedSearches").serviceDetails("LoggingManagement", "ListLogSavedSearches", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/ListLogSavedSearches").method(Method.GET).requestBuilder(ListLogSavedSearchesRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("logSavedSearchId", (Object)request.getLogSavedSearchId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogSavedSearchSummaryCollection.class, ListLogSavedSearchesResponse.Builder::logSavedSearchSummaryCollection).handleResponseHeaderString("opc-next-page", ListLogSavedSearchesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListLogSavedSearchesResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListLogSavedSearchesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLogsResponse> listLogs(ListLogsRequest request, AsyncHandler<ListLogsRequest, ListLogsResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListLogsResponse::builder).logger(LOG, "listLogs").serviceDetails("LoggingManagement", "ListLogs", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSummary/ListLogs").method(Method.GET).requestBuilder(ListLogsRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendEnumQueryParam("logType", (BmcEnum)request.getLogType()).appendQueryParam("sourceService", (Object)request.getSourceService()).appendQueryParam("sourceResource", (Object)request.getSourceResource()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LogSummary.class, ListLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListLogsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListServicesResponse> listServices(ListServicesRequest request, AsyncHandler<ListServicesRequest, ListServicesResponse> handler) {
        return this.clientCall(request, ListServicesResponse::builder).logger(LOG, "listServices").serviceDetails("LoggingManagement", "ListServices", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/ServiceSummary/ListServices").method(Method.GET).requestBuilder(ListServicesRequest::builder).basePath("/20200531").appendPathParam("v2").appendPathParam("registry").appendPathParam("services").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ServiceSummary.class, ListServicesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListServicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListServicesResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListUnifiedAgentConfigurationsResponse> listUnifiedAgentConfigurations(ListUnifiedAgentConfigurationsRequest request, AsyncHandler<ListUnifiedAgentConfigurationsRequest, ListUnifiedAgentConfigurationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListUnifiedAgentConfigurationsResponse::builder).logger(LOG, "listUnifiedAgentConfigurations").serviceDetails("LoggingManagement", "ListUnifiedAgentConfigurations", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/ListUnifiedAgentConfigurations").method(Method.GET).requestBuilder(ListUnifiedAgentConfigurationsRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("logId", (Object)request.getLogId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendQueryParam("groupId", (Object)request.getGroupId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UnifiedAgentConfigurationCollection.class, ListUnifiedAgentConfigurationsResponse.Builder::unifiedAgentConfigurationCollection).handleResponseHeaderString("opc-next-page", ListUnifiedAgentConfigurationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListUnifiedAgentConfigurationsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListUnifiedAgentConfigurationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("LoggingManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("LoggingManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLog.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("LoggingManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateLogResponse> updateLog(UpdateLogRequest request, AsyncHandler<UpdateLogRequest, UpdateLogResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogDetails(), "updateLogDetails is required");
        return this.clientCall(request, UpdateLogResponse::builder).logger(LOG, "updateLog").serviceDetails("LoggingManagement", "UpdateLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/UpdateLog").method(Method.PUT).requestBuilder(UpdateLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLogResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateLogGroupResponse> updateLogGroup(UpdateLogGroupRequest request, AsyncHandler<UpdateLogGroupRequest, UpdateLogGroupResponse> handler) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogGroupDetails(), "updateLogGroupDetails is required");
        return this.clientCall(request, UpdateLogGroupResponse::builder).logger(LOG, "updateLogGroup").serviceDetails("LoggingManagement", "UpdateLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/UpdateLogGroup").method(Method.PUT).requestBuilder(UpdateLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLogGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateLogSavedSearchResponse> updateLogSavedSearch(UpdateLogSavedSearchRequest request, AsyncHandler<UpdateLogSavedSearchRequest, UpdateLogSavedSearchResponse> handler) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogSavedSearchDetails(), "updateLogSavedSearchDetails is required");
        return this.clientCall(request, UpdateLogSavedSearchResponse::builder).logger(LOG, "updateLogSavedSearch").serviceDetails("LoggingManagement", "UpdateLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/UpdateLogSavedSearch").method(Method.PUT).requestBuilder(UpdateLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogSavedSearch.class, UpdateLogSavedSearchResponse.Builder::logSavedSearch).handleResponseHeaderString("opc-request-id", UpdateLogSavedSearchResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateLogSavedSearchResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateUnifiedAgentConfigurationResponse> updateUnifiedAgentConfiguration(UpdateUnifiedAgentConfigurationRequest request, AsyncHandler<UpdateUnifiedAgentConfigurationRequest, UpdateUnifiedAgentConfigurationResponse> handler) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUnifiedAgentConfigurationDetails(), "updateUnifiedAgentConfigurationDetails is required");
        return this.clientCall(request, UpdateUnifiedAgentConfigurationResponse::builder).logger(LOG, "updateUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "UpdateUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/UpdateUnifiedAgentConfiguration").method(Method.PUT).requestBuilder(UpdateUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateUnifiedAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateUnifiedAgentConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public LoggingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LoggingManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LoggingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LoggingManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LoggingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LoggingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LoggingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LoggingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LoggingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LoggingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoggingManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "logging";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"logging");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LoggingManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LoggingManagementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

