/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.logging.LoggingManagement;
import com.oracle.bmc.logging.LoggingManagementPaginators;
import com.oracle.bmc.logging.LoggingManagementWaiters;
import com.oracle.bmc.logging.model.Log;
import com.oracle.bmc.logging.model.LogGroup;
import com.oracle.bmc.logging.model.LogGroupSummary;
import com.oracle.bmc.logging.model.LogSavedSearch;
import com.oracle.bmc.logging.model.LogSavedSearchSummaryCollection;
import com.oracle.bmc.logging.model.LogSummary;
import com.oracle.bmc.logging.model.ServiceSummary;
import com.oracle.bmc.logging.model.UnifiedAgentConfiguration;
import com.oracle.bmc.logging.model.UnifiedAgentConfigurationCollection;
import com.oracle.bmc.logging.model.WorkRequest;
import com.oracle.bmc.logging.model.WorkRequestError;
import com.oracle.bmc.logging.model.WorkRequestLog;
import com.oracle.bmc.logging.model.WorkRequestSummary;
import com.oracle.bmc.logging.requests.ChangeLogGroupCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeLogLogGroupRequest;
import com.oracle.bmc.logging.requests.ChangeLogSavedSearchCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeUnifiedAgentConfigurationCompartmentRequest;
import com.oracle.bmc.logging.requests.CreateLogGroupRequest;
import com.oracle.bmc.logging.requests.CreateLogRequest;
import com.oracle.bmc.logging.requests.CreateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.CreateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteLogGroupRequest;
import com.oracle.bmc.logging.requests.DeleteLogRequest;
import com.oracle.bmc.logging.requests.DeleteLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.DeleteUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.logging.requests.GetLogGroupRequest;
import com.oracle.bmc.logging.requests.GetLogRequest;
import com.oracle.bmc.logging.requests.GetLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.GetUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.GetWorkRequestRequest;
import com.oracle.bmc.logging.requests.ListLogGroupsRequest;
import com.oracle.bmc.logging.requests.ListLogSavedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogsRequest;
import com.oracle.bmc.logging.requests.ListServicesRequest;
import com.oracle.bmc.logging.requests.ListUnifiedAgentConfigurationsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestsRequest;
import com.oracle.bmc.logging.requests.UpdateLogGroupRequest;
import com.oracle.bmc.logging.requests.UpdateLogRequest;
import com.oracle.bmc.logging.requests.UpdateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.UpdateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.responses.ChangeLogGroupCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeLogLogGroupResponse;
import com.oracle.bmc.logging.responses.ChangeLogSavedSearchCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeUnifiedAgentConfigurationCompartmentResponse;
import com.oracle.bmc.logging.responses.CreateLogGroupResponse;
import com.oracle.bmc.logging.responses.CreateLogResponse;
import com.oracle.bmc.logging.responses.CreateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.CreateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteLogGroupResponse;
import com.oracle.bmc.logging.responses.DeleteLogResponse;
import com.oracle.bmc.logging.responses.DeleteLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.DeleteUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.logging.responses.GetLogGroupResponse;
import com.oracle.bmc.logging.responses.GetLogResponse;
import com.oracle.bmc.logging.responses.GetLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.GetUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.GetWorkRequestResponse;
import com.oracle.bmc.logging.responses.ListLogGroupsResponse;
import com.oracle.bmc.logging.responses.ListLogSavedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogsResponse;
import com.oracle.bmc.logging.responses.ListServicesResponse;
import com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestsResponse;
import com.oracle.bmc.logging.responses.UpdateLogGroupResponse;
import com.oracle.bmc.logging.responses.UpdateLogResponse;
import com.oracle.bmc.logging.responses.UpdateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.UpdateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingManagementClient
extends BaseSyncClient
implements LoggingManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGGINGMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://logging.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LoggingManagementClient.class);
    private final LoggingManagementWaiters waiters;
    private final LoggingManagementPaginators paginators;

    LoggingManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("LoggingManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LoggingManagementWaiters(executorService, this);
        this.paginators = new LoggingManagementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeLogGroupCompartmentResponse changeLogGroupCompartment(ChangeLogGroupCompartmentRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogGroupCompartmentDetails(), "changeLogGroupCompartmentDetails is required");
        return (ChangeLogGroupCompartmentResponse)this.clientCall(request, ChangeLogGroupCompartmentResponse::builder).logger(LOG, "changeLogGroupCompartment").serviceDetails("LoggingManagement", "ChangeLogGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/ChangeLogGroupCompartment").method(Method.POST).requestBuilder(ChangeLogGroupCompartmentRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeLogGroupCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeLogGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeLogLogGroupResponse changeLogLogGroup(ChangeLogLogGroupRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogLogGroupDetails(), "changeLogLogGroupDetails is required");
        return (ChangeLogLogGroupResponse)this.clientCall(request, ChangeLogLogGroupResponse::builder).logger(LOG, "changeLogLogGroup").serviceDetails("LoggingManagement", "ChangeLogLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/ChangeLogLogGroup").method(Method.POST).requestBuilder(ChangeLogLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).appendPathParam("actions").appendPathParam("changeLogGroup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeLogLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeLogLogGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeLogSavedSearchCompartmentResponse changeLogSavedSearchCompartment(ChangeLogSavedSearchCompartmentRequest request) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeLogSavedSearchCompartmentDetails(), "changeLogSavedSearchCompartmentDetails is required");
        return (ChangeLogSavedSearchCompartmentResponse)this.clientCall(request, ChangeLogSavedSearchCompartmentResponse::builder).logger(LOG, "changeLogSavedSearchCompartment").serviceDetails("LoggingManagement", "ChangeLogSavedSearchCompartment", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/ChangeLogSavedSearchCompartment").method(Method.POST).requestBuilder(ChangeLogSavedSearchCompartmentRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeLogSavedSearchCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeUnifiedAgentConfigurationCompartmentResponse changeUnifiedAgentConfigurationCompartment(ChangeUnifiedAgentConfigurationCompartmentRequest request) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeUnifiedAgentConfigurationCompartmentDetails(), "changeUnifiedAgentConfigurationCompartmentDetails is required");
        return (ChangeUnifiedAgentConfigurationCompartmentResponse)this.clientCall(request, ChangeUnifiedAgentConfigurationCompartmentResponse::builder).logger(LOG, "changeUnifiedAgentConfigurationCompartment").serviceDetails("LoggingManagement", "ChangeUnifiedAgentConfigurationCompartment", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/ChangeUnifiedAgentConfigurationCompartment").method(Method.POST).requestBuilder(ChangeUnifiedAgentConfigurationCompartmentRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeUnifiedAgentConfigurationCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeUnifiedAgentConfigurationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateLogResponse createLog(CreateLogRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateLogDetails(), "createLogDetails is required");
        return (CreateLogResponse)this.clientCall(request, CreateLogResponse::builder).logger(LOG, "createLog").serviceDetails("LoggingManagement", "CreateLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/CreateLog").method(Method.POST).requestBuilder(CreateLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateLogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateLogGroupResponse createLogGroup(CreateLogGroupRequest request) {
        Objects.requireNonNull(request.getCreateLogGroupDetails(), "createLogGroupDetails is required");
        return (CreateLogGroupResponse)this.clientCall(request, CreateLogGroupResponse::builder).logger(LOG, "createLogGroup").serviceDetails("LoggingManagement", "CreateLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/CreateLogGroup").method(Method.POST).requestBuilder(CreateLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateLogGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateLogSavedSearchResponse createLogSavedSearch(CreateLogSavedSearchRequest request) {
        Objects.requireNonNull(request.getCreateLogSavedSearchDetails(), "createLogSavedSearchDetails is required");
        return (CreateLogSavedSearchResponse)this.clientCall(request, CreateLogSavedSearchResponse::builder).logger(LOG, "createLogSavedSearch").serviceDetails("LoggingManagement", "CreateLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/CreateLogSavedSearch").method(Method.POST).requestBuilder(CreateLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogSavedSearch.class, CreateLogSavedSearchResponse.Builder::logSavedSearch).handleResponseHeaderString("opc-request-id", CreateLogSavedSearchResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateLogSavedSearchResponse.Builder::etag).callSync();
    }

    @Override
    public CreateUnifiedAgentConfigurationResponse createUnifiedAgentConfiguration(CreateUnifiedAgentConfigurationRequest request) {
        Objects.requireNonNull(request.getCreateUnifiedAgentConfigurationDetails(), "createUnifiedAgentConfigurationDetails is required");
        return (CreateUnifiedAgentConfigurationResponse)this.clientCall(request, CreateUnifiedAgentConfigurationResponse::builder).logger(LOG, "createUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "CreateUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/CreateUnifiedAgentConfiguration").method(Method.POST).requestBuilder(CreateUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateUnifiedAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateUnifiedAgentConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLogResponse deleteLog(DeleteLogRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        return (DeleteLogResponse)this.clientCall(request, DeleteLogResponse::builder).logger(LOG, "deleteLog").serviceDetails("LoggingManagement", "DeleteLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/DeleteLog").method(Method.DELETE).requestBuilder(DeleteLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteLogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLogGroupResponse deleteLogGroup(DeleteLogGroupRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteLogGroupResponse)this.clientCall(request, DeleteLogGroupResponse::builder).logger(LOG, "deleteLogGroup").serviceDetails("LoggingManagement", "DeleteLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/DeleteLogGroup").method(Method.DELETE).requestBuilder(DeleteLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteLogGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteLogSavedSearchResponse deleteLogSavedSearch(DeleteLogSavedSearchRequest request) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        return (DeleteLogSavedSearchResponse)this.clientCall(request, DeleteLogSavedSearchResponse::builder).logger(LOG, "deleteLogSavedSearch").serviceDetails("LoggingManagement", "DeleteLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/DeleteLogSavedSearch").method(Method.DELETE).requestBuilder(DeleteLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteLogSavedSearchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteUnifiedAgentConfigurationResponse deleteUnifiedAgentConfiguration(DeleteUnifiedAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        return (DeleteUnifiedAgentConfigurationResponse)this.clientCall(request, DeleteUnifiedAgentConfigurationResponse::builder).logger(LOG, "deleteUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "DeleteUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/DeleteUnifiedAgentConfiguration").method(Method.DELETE).requestBuilder(DeleteUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteUnifiedAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteUnifiedAgentConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (DeleteWorkRequestResponse)this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("LoggingManagement", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWorkRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetLogResponse getLog(GetLogRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        return (GetLogResponse)this.clientCall(request, GetLogResponse::builder).logger(LOG, "getLog").serviceDetails("LoggingManagement", "GetLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/GetLog").method(Method.GET).requestBuilder(GetLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Log.class, GetLogResponse.Builder::log).handleResponseHeaderString("opc-request-id", GetLogResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetLogResponse.Builder::etag).callSync();
    }

    @Override
    public GetLogGroupResponse getLogGroup(GetLogGroupRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        return (GetLogGroupResponse)this.clientCall(request, GetLogGroupResponse::builder).logger(LOG, "getLogGroup").serviceDetails("LoggingManagement", "GetLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/GetLogGroup").method(Method.GET).requestBuilder(GetLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogGroup.class, GetLogGroupResponse.Builder::logGroup).handleResponseHeaderString("opc-request-id", GetLogGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetLogGroupResponse.Builder::etag).callSync();
    }

    @Override
    public GetLogSavedSearchResponse getLogSavedSearch(GetLogSavedSearchRequest request) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        return (GetLogSavedSearchResponse)this.clientCall(request, GetLogSavedSearchResponse::builder).logger(LOG, "getLogSavedSearch").serviceDetails("LoggingManagement", "GetLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/GetLogSavedSearch").method(Method.GET).requestBuilder(GetLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogSavedSearch.class, GetLogSavedSearchResponse.Builder::logSavedSearch).handleResponseHeaderString("opc-request-id", GetLogSavedSearchResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetLogSavedSearchResponse.Builder::etag).callSync();
    }

    @Override
    public GetUnifiedAgentConfigurationResponse getUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        return (GetUnifiedAgentConfigurationResponse)this.clientCall(request, GetUnifiedAgentConfigurationResponse::builder).logger(LOG, "getUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "GetUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/GetUnifiedAgentConfiguration").method(Method.GET).requestBuilder(GetUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UnifiedAgentConfiguration.class, GetUnifiedAgentConfigurationResponse.Builder::unifiedAgentConfiguration).handleResponseHeaderString("opc-request-id", GetUnifiedAgentConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetUnifiedAgentConfigurationResponse.Builder::etag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("LoggingManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderBigDecimal("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListLogGroupsResponse listLogGroups(ListLogGroupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLogGroupsResponse)this.clientCall(request, ListLogGroupsResponse::builder).logger(LOG, "listLogGroups").serviceDetails("LoggingManagement", "ListLogGroups", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroupSummary/ListLogGroups").method(Method.GET).requestBuilder(ListLogGroupsRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LogGroupSummary.class, ListLogGroupsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLogGroupsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListLogGroupsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListLogGroupsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLogSavedSearchesResponse listLogSavedSearches(ListLogSavedSearchesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListLogSavedSearchesResponse)this.clientCall(request, ListLogSavedSearchesResponse::builder).logger(LOG, "listLogSavedSearches").serviceDetails("LoggingManagement", "ListLogSavedSearches", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/ListLogSavedSearches").method(Method.GET).requestBuilder(ListLogSavedSearchesRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("logSavedSearchId", (Object)request.getLogSavedSearchId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LogSavedSearchSummaryCollection.class, ListLogSavedSearchesResponse.Builder::logSavedSearchSummaryCollection).handleResponseHeaderString("opc-next-page", ListLogSavedSearchesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListLogSavedSearchesResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListLogSavedSearchesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListLogsResponse listLogs(ListLogsRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        return (ListLogsResponse)this.clientCall(request, ListLogsResponse::builder).logger(LOG, "listLogs").serviceDetails("LoggingManagement", "ListLogs", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSummary/ListLogs").method(Method.GET).requestBuilder(ListLogsRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendEnumQueryParam("logType", (BmcEnum)request.getLogType()).appendQueryParam("sourceService", (Object)request.getSourceService()).appendQueryParam("sourceResource", (Object)request.getSourceResource()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LogSummary.class, ListLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListLogsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListServicesResponse listServices(ListServicesRequest request) {
        return (ListServicesResponse)this.clientCall(request, ListServicesResponse::builder).logger(LOG, "listServices").serviceDetails("LoggingManagement", "ListServices", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/ServiceSummary/ListServices").method(Method.GET).requestBuilder(ListServicesRequest::builder).basePath("/20200531").appendPathParam("v2").appendPathParam("registry").appendPathParam("services").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ServiceSummary.class, ListServicesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListServicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListServicesResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListUnifiedAgentConfigurationsResponse listUnifiedAgentConfigurations(ListUnifiedAgentConfigurationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListUnifiedAgentConfigurationsResponse)this.clientCall(request, ListUnifiedAgentConfigurationsResponse::builder).logger(LOG, "listUnifiedAgentConfigurations").serviceDetails("LoggingManagement", "ListUnifiedAgentConfigurations", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/ListUnifiedAgentConfigurations").method(Method.GET).requestBuilder(ListUnifiedAgentConfigurationsRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("logId", (Object)request.getLogId()).appendQueryParam("isCompartmentIdInSubtree", (Object)request.getIsCompartmentIdInSubtree()).appendQueryParam("groupId", (Object)request.getGroupId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UnifiedAgentConfigurationCollection.class, ListUnifiedAgentConfigurationsResponse.Builder::unifiedAgentConfigurationCollection).handleResponseHeaderString("opc-next-page", ListUnifiedAgentConfigurationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListUnifiedAgentConfigurationsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListUnifiedAgentConfigurationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("LoggingManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("LoggingManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLog.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("LoggingManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200531").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLogResponse updateLog(UpdateLogRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLogId(), (String)"logId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogDetails(), "updateLogDetails is required");
        return (UpdateLogResponse)this.clientCall(request, UpdateLogResponse::builder).logger(LOG, "updateLog").serviceDetails("LoggingManagement", "UpdateLog", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/Log/UpdateLog").method(Method.PUT).requestBuilder(UpdateLogRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).appendPathParam("logs").appendPathParam(request.getLogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLogGroupResponse updateLogGroup(UpdateLogGroupRequest request) {
        Validate.notBlank((String)request.getLogGroupId(), (String)"logGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogGroupDetails(), "updateLogGroupDetails is required");
        return (UpdateLogGroupResponse)this.clientCall(request, UpdateLogGroupResponse::builder).logger(LOG, "updateLogGroup").serviceDetails("LoggingManagement", "UpdateLogGroup", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogGroup/UpdateLogGroup").method(Method.PUT).requestBuilder(UpdateLogGroupRequest::builder).basePath("/20200531").appendPathParam("logGroups").appendPathParam(request.getLogGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateLogGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateLogGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateLogSavedSearchResponse updateLogSavedSearch(UpdateLogSavedSearchRequest request) {
        Validate.notBlank((String)request.getLogSavedSearchId(), (String)"logSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateLogSavedSearchDetails(), "updateLogSavedSearchDetails is required");
        return (UpdateLogSavedSearchResponse)this.clientCall(request, UpdateLogSavedSearchResponse::builder).logger(LOG, "updateLogSavedSearch").serviceDetails("LoggingManagement", "UpdateLogSavedSearch", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/LogSavedSearch/UpdateLogSavedSearch").method(Method.PUT).requestBuilder(UpdateLogSavedSearchRequest::builder).basePath("/20200531").appendPathParam("logSavedSearches").appendPathParam(request.getLogSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(LogSavedSearch.class, UpdateLogSavedSearchResponse.Builder::logSavedSearch).handleResponseHeaderString("opc-request-id", UpdateLogSavedSearchResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateLogSavedSearchResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateUnifiedAgentConfigurationResponse updateUnifiedAgentConfiguration(UpdateUnifiedAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getUnifiedAgentConfigurationId(), (String)"unifiedAgentConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUnifiedAgentConfigurationDetails(), "updateUnifiedAgentConfigurationDetails is required");
        return (UpdateUnifiedAgentConfigurationResponse)this.clientCall(request, UpdateUnifiedAgentConfigurationResponse::builder).logger(LOG, "updateUnifiedAgentConfiguration").serviceDetails("LoggingManagement", "UpdateUnifiedAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/logging-management/20200531/UnifiedAgentConfiguration/UpdateUnifiedAgentConfiguration").method(Method.PUT).requestBuilder(UpdateUnifiedAgentConfigurationRequest::builder).basePath("/20200531").appendPathParam("unifiedAgentConfigurations").appendPathParam(request.getUnifiedAgentConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateUnifiedAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateUnifiedAgentConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public LoggingManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LoggingManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public LoggingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LoggingManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LoggingManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LoggingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LoggingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LoggingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LoggingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LoggingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public LoggingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LoggingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoggingManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "logging";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"logging");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LoggingManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LoggingManagementClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

