/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.Source;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class OciService
extends Source {
    @JsonProperty(value="service")
    private final String service;
    @JsonProperty(value="resource")
    private final String resource;
    @JsonProperty(value="category")
    private final String category;
    @JsonProperty(value="parameters")
    private final Map<String, String> parameters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciService(String service, String resource, String category, Map<String, String> parameters) {
        this.service = service;
        this.resource = resource;
        this.category = category;
        this.parameters = parameters;
    }

    public String getService() {
        return this.service;
    }

    public String getResource() {
        return this.resource;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciService(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", service=").append(String.valueOf(this.service));
        sb.append(", resource=").append(String.valueOf(this.resource));
        sb.append(", category=").append(String.valueOf(this.category));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciService)) {
            return false;
        }
        OciService other = (OciService)((Object)o);
        return Objects.equals(this.service, other.service) && Objects.equals(this.resource, other.resource) && Objects.equals(this.category, other.category) && Objects.equals(this.parameters, other.parameters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.resource == null ? 43 : this.resource.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="service")
        private String service;
        @JsonProperty(value="resource")
        private String resource;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="parameters")
        private Map<String, String> parameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            this.__explicitlySet__.add("resource");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public OciService build() {
            OciService model = new OciService(this.service, this.resource, this.category, this.parameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciService model) {
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("resource")) {
                this.resource(model.getResource());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            return this;
        }
    }
}

