/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.UnifiedAgentCustomSection;
import com.oracle.bmc.logging.model.UnifiedAgentLoggingFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="filterType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentCustomFilter
extends UnifiedAgentLoggingFilter {
    @JsonProperty(value="customFilterType")
    private final String customFilterType;
    @JsonProperty(value="params")
    private final Map<String, String> params;
    @JsonProperty(value="customSections")
    private final List<UnifiedAgentCustomSection> customSections;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentCustomFilter(String name, String customFilterType, Map<String, String> params, List<UnifiedAgentCustomSection> customSections) {
        super(name);
        this.customFilterType = customFilterType;
        this.params = params;
        this.customSections = customSections;
    }

    public String getCustomFilterType() {
        return this.customFilterType;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public List<UnifiedAgentCustomSection> getCustomSections() {
        return this.customSections;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentCustomFilter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", customFilterType=").append(String.valueOf(this.customFilterType));
        sb.append(", params=").append(String.valueOf(this.params));
        sb.append(", customSections=").append(String.valueOf(this.customSections));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentCustomFilter)) {
            return false;
        }
        UnifiedAgentCustomFilter other = (UnifiedAgentCustomFilter)((Object)o);
        return Objects.equals(this.customFilterType, other.customFilterType) && Objects.equals(this.params, other.params) && Objects.equals(this.customSections, other.customSections) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.customFilterType == null ? 43 : this.customFilterType.hashCode());
        result = result * 59 + (this.params == null ? 43 : this.params.hashCode());
        result = result * 59 + (this.customSections == null ? 43 : this.customSections.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="customFilterType")
        private String customFilterType;
        @JsonProperty(value="params")
        private Map<String, String> params;
        @JsonProperty(value="customSections")
        private List<UnifiedAgentCustomSection> customSections;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder customFilterType(String customFilterType) {
            this.customFilterType = customFilterType;
            this.__explicitlySet__.add("customFilterType");
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            this.__explicitlySet__.add("params");
            return this;
        }

        public Builder customSections(List<UnifiedAgentCustomSection> customSections) {
            this.customSections = customSections;
            this.__explicitlySet__.add("customSections");
            return this;
        }

        public UnifiedAgentCustomFilter build() {
            UnifiedAgentCustomFilter model = new UnifiedAgentCustomFilter(this.name, this.customFilterType, this.params, this.customSections);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentCustomFilter model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("customFilterType")) {
                this.customFilterType(model.getCustomFilterType());
            }
            if (model.wasPropertyExplicitlySet("params")) {
                this.params(model.getParams());
            }
            if (model.wasPropertyExplicitlySet("customSections")) {
                this.customSections(model.getCustomSections());
            }
            return this;
        }
    }
}

