/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.GrokPattern;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="parserType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentGrokParser
extends UnifiedAgentParser {
    @JsonProperty(value="grokNameKey")
    private final String grokNameKey;
    @JsonProperty(value="grokFailureKey")
    private final String grokFailureKey;
    @JsonProperty(value="patterns")
    private final List<GrokPattern> patterns;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentGrokParser(String fieldTimeKey, Map<String, String> types, String nullValuePattern, Boolean isNullEmptyString, Boolean isEstimateCurrentEvent, Boolean isKeepTimeKey, Integer timeoutInMilliseconds, String grokNameKey, String grokFailureKey, List<GrokPattern> patterns) {
        super(fieldTimeKey, types, nullValuePattern, isNullEmptyString, isEstimateCurrentEvent, isKeepTimeKey, timeoutInMilliseconds);
        this.grokNameKey = grokNameKey;
        this.grokFailureKey = grokFailureKey;
        this.patterns = patterns;
    }

    public String getGrokNameKey() {
        return this.grokNameKey;
    }

    public String getGrokFailureKey() {
        return this.grokFailureKey;
    }

    public List<GrokPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentGrokParser(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", grokNameKey=").append(String.valueOf(this.grokNameKey));
        sb.append(", grokFailureKey=").append(String.valueOf(this.grokFailureKey));
        sb.append(", patterns=").append(String.valueOf(this.patterns));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentGrokParser)) {
            return false;
        }
        UnifiedAgentGrokParser other = (UnifiedAgentGrokParser)((Object)o);
        return Objects.equals(this.grokNameKey, other.grokNameKey) && Objects.equals(this.grokFailureKey, other.grokFailureKey) && Objects.equals(this.patterns, other.patterns) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.grokNameKey == null ? 43 : this.grokNameKey.hashCode());
        result = result * 59 + (this.grokFailureKey == null ? 43 : this.grokFailureKey.hashCode());
        result = result * 59 + (this.patterns == null ? 43 : this.patterns.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldTimeKey")
        private String fieldTimeKey;
        @JsonProperty(value="types")
        private Map<String, String> types;
        @JsonProperty(value="nullValuePattern")
        private String nullValuePattern;
        @JsonProperty(value="isNullEmptyString")
        private Boolean isNullEmptyString;
        @JsonProperty(value="isEstimateCurrentEvent")
        private Boolean isEstimateCurrentEvent;
        @JsonProperty(value="isKeepTimeKey")
        private Boolean isKeepTimeKey;
        @JsonProperty(value="timeoutInMilliseconds")
        private Integer timeoutInMilliseconds;
        @JsonProperty(value="grokNameKey")
        private String grokNameKey;
        @JsonProperty(value="grokFailureKey")
        private String grokFailureKey;
        @JsonProperty(value="patterns")
        private List<GrokPattern> patterns;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldTimeKey(String fieldTimeKey) {
            this.fieldTimeKey = fieldTimeKey;
            this.__explicitlySet__.add("fieldTimeKey");
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types = types;
            this.__explicitlySet__.add("types");
            return this;
        }

        public Builder nullValuePattern(String nullValuePattern) {
            this.nullValuePattern = nullValuePattern;
            this.__explicitlySet__.add("nullValuePattern");
            return this;
        }

        public Builder isNullEmptyString(Boolean isNullEmptyString) {
            this.isNullEmptyString = isNullEmptyString;
            this.__explicitlySet__.add("isNullEmptyString");
            return this;
        }

        public Builder isEstimateCurrentEvent(Boolean isEstimateCurrentEvent) {
            this.isEstimateCurrentEvent = isEstimateCurrentEvent;
            this.__explicitlySet__.add("isEstimateCurrentEvent");
            return this;
        }

        public Builder isKeepTimeKey(Boolean isKeepTimeKey) {
            this.isKeepTimeKey = isKeepTimeKey;
            this.__explicitlySet__.add("isKeepTimeKey");
            return this;
        }

        public Builder timeoutInMilliseconds(Integer timeoutInMilliseconds) {
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.__explicitlySet__.add("timeoutInMilliseconds");
            return this;
        }

        public Builder grokNameKey(String grokNameKey) {
            this.grokNameKey = grokNameKey;
            this.__explicitlySet__.add("grokNameKey");
            return this;
        }

        public Builder grokFailureKey(String grokFailureKey) {
            this.grokFailureKey = grokFailureKey;
            this.__explicitlySet__.add("grokFailureKey");
            return this;
        }

        public Builder patterns(List<GrokPattern> patterns) {
            this.patterns = patterns;
            this.__explicitlySet__.add("patterns");
            return this;
        }

        public UnifiedAgentGrokParser build() {
            UnifiedAgentGrokParser model = new UnifiedAgentGrokParser(this.fieldTimeKey, this.types, this.nullValuePattern, this.isNullEmptyString, this.isEstimateCurrentEvent, this.isKeepTimeKey, this.timeoutInMilliseconds, this.grokNameKey, this.grokFailureKey, this.patterns);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentGrokParser model) {
            if (model.wasPropertyExplicitlySet("fieldTimeKey")) {
                this.fieldTimeKey(model.getFieldTimeKey());
            }
            if (model.wasPropertyExplicitlySet("types")) {
                this.types(model.getTypes());
            }
            if (model.wasPropertyExplicitlySet("nullValuePattern")) {
                this.nullValuePattern(model.getNullValuePattern());
            }
            if (model.wasPropertyExplicitlySet("isNullEmptyString")) {
                this.isNullEmptyString(model.getIsNullEmptyString());
            }
            if (model.wasPropertyExplicitlySet("isEstimateCurrentEvent")) {
                this.isEstimateCurrentEvent(model.getIsEstimateCurrentEvent());
            }
            if (model.wasPropertyExplicitlySet("isKeepTimeKey")) {
                this.isKeepTimeKey(model.getIsKeepTimeKey());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMilliseconds")) {
                this.timeoutInMilliseconds(model.getTimeoutInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("grokNameKey")) {
                this.grokNameKey(model.getGrokNameKey());
            }
            if (model.wasPropertyExplicitlySet("grokFailureKey")) {
                this.grokFailureKey(model.getGrokFailureKey());
            }
            if (model.wasPropertyExplicitlySet("patterns")) {
                this.patterns(model.getPatterns());
            }
            return this;
        }
    }
}

