/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentKubernetesScrapeTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="k8sNamespace")
    private final String k8sNamespace;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="resourceGroup")
    private final String resourceGroup;

    @Deprecated
    @ConstructorProperties(value={"resourceType", "k8sNamespace", "serviceName", "resourceGroup"})
    public UnifiedAgentKubernetesScrapeTarget(ResourceType resourceType, String k8sNamespace, String serviceName, String resourceGroup) {
        this.resourceType = resourceType;
        this.k8sNamespace = k8sNamespace;
        this.serviceName = serviceName;
        this.resourceGroup = resourceGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getK8sNamespace() {
        return this.k8sNamespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentKubernetesScrapeTarget(");
        sb.append("super=").append(super.toString());
        sb.append("resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", k8sNamespace=").append(String.valueOf(this.k8sNamespace));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", resourceGroup=").append(String.valueOf(this.resourceGroup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentKubernetesScrapeTarget)) {
            return false;
        }
        UnifiedAgentKubernetesScrapeTarget other = (UnifiedAgentKubernetesScrapeTarget)((Object)o);
        return Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.k8sNamespace, other.k8sNamespace) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.resourceGroup, other.resourceGroup) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.k8sNamespace == null ? 43 : this.k8sNamespace.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.resourceGroup == null ? 43 : this.resourceGroup.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        Pods("PODS"),
        Endpoints("ENDPOINTS"),
        Nodes("NODES"),
        Services("SERVICES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="k8sNamespace")
        private String k8sNamespace;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="resourceGroup")
        private String resourceGroup;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder k8sNamespace(String k8sNamespace) {
            this.k8sNamespace = k8sNamespace;
            this.__explicitlySet__.add("k8sNamespace");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            this.__explicitlySet__.add("resourceGroup");
            return this;
        }

        public UnifiedAgentKubernetesScrapeTarget build() {
            UnifiedAgentKubernetesScrapeTarget model = new UnifiedAgentKubernetesScrapeTarget(this.resourceType, this.k8sNamespace, this.serviceName, this.resourceGroup);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentKubernetesScrapeTarget model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("k8sNamespace")) {
                this.k8sNamespace(model.getK8sNamespace());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("resourceGroup")) {
                this.resourceGroup(model.getResourceGroup());
            }
            return this;
        }
    }
}

