/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.logging.model.UnifiedAgentCustomFilter;
import com.oracle.bmc.logging.model.UnifiedAgentLoggingGrepFilter;
import com.oracle.bmc.logging.model.UnifiedAgentLoggingRecordTransformerFilter;
import com.oracle.bmc.logging.model.UnifiedAgentParserFilter;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="filterType", defaultImpl=UnifiedAgentLoggingFilter.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UnifiedAgentCustomFilter.class, name="CUSTOM_FILTER"), @JsonSubTypes.Type(value=UnifiedAgentParserFilter.class, name="PARSER_FILTER"), @JsonSubTypes.Type(value=UnifiedAgentLoggingGrepFilter.class, name="GREP_FILTER"), @JsonSubTypes.Type(value=UnifiedAgentLoggingRecordTransformerFilter.class, name="RECORD_TRANSFORMER_FILTER")})
@JsonFilter(value="explicitlySetFilter")
public class UnifiedAgentLoggingFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;

    @Deprecated
    @ConstructorProperties(value={"name"})
    protected UnifiedAgentLoggingFilter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentLoggingFilter(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentLoggingFilter)) {
            return false;
        }
        UnifiedAgentLoggingFilter other = (UnifiedAgentLoggingFilter)((Object)o);
        return Objects.equals(this.name, other.name) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FilterType implements BmcEnum
    {
        ParserFilter("PARSER_FILTER"),
        GrepFilter("GREP_FILTER"),
        RecordTransformerFilter("RECORD_TRANSFORMER_FILTER"),
        CustomFilter("CUSTOM_FILTER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FilterType> map;

        private FilterType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FilterType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FilterType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FilterType.class);
            map = new HashMap<String, FilterType>();
            for (FilterType v : FilterType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

