/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.GrokPattern;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="parserType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentMultilineGrokParser
extends UnifiedAgentParser {
    @JsonProperty(value="grokNameKey")
    private final String grokNameKey;
    @JsonProperty(value="grokFailureKey")
    private final String grokFailureKey;
    @JsonProperty(value="multiLineStartRegexp")
    private final String multiLineStartRegexp;
    @JsonProperty(value="patterns")
    private final List<GrokPattern> patterns;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentMultilineGrokParser(String fieldTimeKey, Map<String, String> types, String nullValuePattern, Boolean isNullEmptyString, Boolean isEstimateCurrentEvent, Boolean isKeepTimeKey, Integer timeoutInMilliseconds, String grokNameKey, String grokFailureKey, String multiLineStartRegexp, List<GrokPattern> patterns) {
        super(fieldTimeKey, types, nullValuePattern, isNullEmptyString, isEstimateCurrentEvent, isKeepTimeKey, timeoutInMilliseconds);
        this.grokNameKey = grokNameKey;
        this.grokFailureKey = grokFailureKey;
        this.multiLineStartRegexp = multiLineStartRegexp;
        this.patterns = patterns;
    }

    public String getGrokNameKey() {
        return this.grokNameKey;
    }

    public String getGrokFailureKey() {
        return this.grokFailureKey;
    }

    public String getMultiLineStartRegexp() {
        return this.multiLineStartRegexp;
    }

    public List<GrokPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentMultilineGrokParser(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", grokNameKey=").append(String.valueOf(this.grokNameKey));
        sb.append(", grokFailureKey=").append(String.valueOf(this.grokFailureKey));
        sb.append(", multiLineStartRegexp=").append(String.valueOf(this.multiLineStartRegexp));
        sb.append(", patterns=").append(String.valueOf(this.patterns));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentMultilineGrokParser)) {
            return false;
        }
        UnifiedAgentMultilineGrokParser other = (UnifiedAgentMultilineGrokParser)((Object)o);
        return Objects.equals(this.grokNameKey, other.grokNameKey) && Objects.equals(this.grokFailureKey, other.grokFailureKey) && Objects.equals(this.multiLineStartRegexp, other.multiLineStartRegexp) && Objects.equals(this.patterns, other.patterns) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.grokNameKey == null ? 43 : this.grokNameKey.hashCode());
        result = result * 59 + (this.grokFailureKey == null ? 43 : this.grokFailureKey.hashCode());
        result = result * 59 + (this.multiLineStartRegexp == null ? 43 : this.multiLineStartRegexp.hashCode());
        result = result * 59 + (this.patterns == null ? 43 : this.patterns.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldTimeKey")
        private String fieldTimeKey;
        @JsonProperty(value="types")
        private Map<String, String> types;
        @JsonProperty(value="nullValuePattern")
        private String nullValuePattern;
        @JsonProperty(value="isNullEmptyString")
        private Boolean isNullEmptyString;
        @JsonProperty(value="isEstimateCurrentEvent")
        private Boolean isEstimateCurrentEvent;
        @JsonProperty(value="isKeepTimeKey")
        private Boolean isKeepTimeKey;
        @JsonProperty(value="timeoutInMilliseconds")
        private Integer timeoutInMilliseconds;
        @JsonProperty(value="grokNameKey")
        private String grokNameKey;
        @JsonProperty(value="grokFailureKey")
        private String grokFailureKey;
        @JsonProperty(value="multiLineStartRegexp")
        private String multiLineStartRegexp;
        @JsonProperty(value="patterns")
        private List<GrokPattern> patterns;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldTimeKey(String fieldTimeKey) {
            this.fieldTimeKey = fieldTimeKey;
            this.__explicitlySet__.add("fieldTimeKey");
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types = types;
            this.__explicitlySet__.add("types");
            return this;
        }

        public Builder nullValuePattern(String nullValuePattern) {
            this.nullValuePattern = nullValuePattern;
            this.__explicitlySet__.add("nullValuePattern");
            return this;
        }

        public Builder isNullEmptyString(Boolean isNullEmptyString) {
            this.isNullEmptyString = isNullEmptyString;
            this.__explicitlySet__.add("isNullEmptyString");
            return this;
        }

        public Builder isEstimateCurrentEvent(Boolean isEstimateCurrentEvent) {
            this.isEstimateCurrentEvent = isEstimateCurrentEvent;
            this.__explicitlySet__.add("isEstimateCurrentEvent");
            return this;
        }

        public Builder isKeepTimeKey(Boolean isKeepTimeKey) {
            this.isKeepTimeKey = isKeepTimeKey;
            this.__explicitlySet__.add("isKeepTimeKey");
            return this;
        }

        public Builder timeoutInMilliseconds(Integer timeoutInMilliseconds) {
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.__explicitlySet__.add("timeoutInMilliseconds");
            return this;
        }

        public Builder grokNameKey(String grokNameKey) {
            this.grokNameKey = grokNameKey;
            this.__explicitlySet__.add("grokNameKey");
            return this;
        }

        public Builder grokFailureKey(String grokFailureKey) {
            this.grokFailureKey = grokFailureKey;
            this.__explicitlySet__.add("grokFailureKey");
            return this;
        }

        public Builder multiLineStartRegexp(String multiLineStartRegexp) {
            this.multiLineStartRegexp = multiLineStartRegexp;
            this.__explicitlySet__.add("multiLineStartRegexp");
            return this;
        }

        public Builder patterns(List<GrokPattern> patterns) {
            this.patterns = patterns;
            this.__explicitlySet__.add("patterns");
            return this;
        }

        public UnifiedAgentMultilineGrokParser build() {
            UnifiedAgentMultilineGrokParser model = new UnifiedAgentMultilineGrokParser(this.fieldTimeKey, this.types, this.nullValuePattern, this.isNullEmptyString, this.isEstimateCurrentEvent, this.isKeepTimeKey, this.timeoutInMilliseconds, this.grokNameKey, this.grokFailureKey, this.multiLineStartRegexp, this.patterns);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentMultilineGrokParser model) {
            if (model.wasPropertyExplicitlySet("fieldTimeKey")) {
                this.fieldTimeKey(model.getFieldTimeKey());
            }
            if (model.wasPropertyExplicitlySet("types")) {
                this.types(model.getTypes());
            }
            if (model.wasPropertyExplicitlySet("nullValuePattern")) {
                this.nullValuePattern(model.getNullValuePattern());
            }
            if (model.wasPropertyExplicitlySet("isNullEmptyString")) {
                this.isNullEmptyString(model.getIsNullEmptyString());
            }
            if (model.wasPropertyExplicitlySet("isEstimateCurrentEvent")) {
                this.isEstimateCurrentEvent(model.getIsEstimateCurrentEvent());
            }
            if (model.wasPropertyExplicitlySet("isKeepTimeKey")) {
                this.isKeepTimeKey(model.getIsKeepTimeKey());
            }
            if (model.wasPropertyExplicitlySet("timeoutInMilliseconds")) {
                this.timeoutInMilliseconds(model.getTimeoutInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("grokNameKey")) {
                this.grokNameKey(model.getGrokNameKey());
            }
            if (model.wasPropertyExplicitlySet("grokFailureKey")) {
                this.grokFailureKey(model.getGrokFailureKey());
            }
            if (model.wasPropertyExplicitlySet("multiLineStartRegexp")) {
                this.multiLineStartRegexp(model.getMultiLineStartRegexp());
            }
            if (model.wasPropertyExplicitlySet("patterns")) {
                this.patterns(model.getPatterns());
            }
            return this;
        }
    }
}

