/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.UnifiedAgentLoggingSource;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import com.oracle.bmc.logging.model.UnifiedAgentTailSourceAdvancedOptions;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentTailLogSource
extends UnifiedAgentLoggingSource {
    @JsonProperty(value="paths")
    private final List<String> paths;
    @JsonProperty(value="parser")
    private final UnifiedAgentParser parser;
    @JsonProperty(value="advancedOptions")
    private final UnifiedAgentTailSourceAdvancedOptions advancedOptions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UnifiedAgentTailLogSource(String name, List<String> paths, UnifiedAgentParser parser, UnifiedAgentTailSourceAdvancedOptions advancedOptions) {
        super(name);
        this.paths = paths;
        this.parser = parser;
        this.advancedOptions = advancedOptions;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public UnifiedAgentParser getParser() {
        return this.parser;
    }

    public UnifiedAgentTailSourceAdvancedOptions getAdvancedOptions() {
        return this.advancedOptions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentTailLogSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", paths=").append(String.valueOf(this.paths));
        sb.append(", parser=").append(String.valueOf((Object)this.parser));
        sb.append(", advancedOptions=").append(String.valueOf((Object)this.advancedOptions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentTailLogSource)) {
            return false;
        }
        UnifiedAgentTailLogSource other = (UnifiedAgentTailLogSource)((Object)o);
        return Objects.equals(this.paths, other.paths) && Objects.equals((Object)this.parser, (Object)other.parser) && Objects.equals((Object)this.advancedOptions, (Object)other.advancedOptions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.paths == null ? 43 : this.paths.hashCode());
        result = result * 59 + (this.parser == null ? 43 : this.parser.hashCode());
        result = result * 59 + (this.advancedOptions == null ? 43 : this.advancedOptions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="paths")
        private List<String> paths;
        @JsonProperty(value="parser")
        private UnifiedAgentParser parser;
        @JsonProperty(value="advancedOptions")
        private UnifiedAgentTailSourceAdvancedOptions advancedOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder paths(List<String> paths) {
            this.paths = paths;
            this.__explicitlySet__.add("paths");
            return this;
        }

        public Builder parser(UnifiedAgentParser parser) {
            this.parser = parser;
            this.__explicitlySet__.add("parser");
            return this;
        }

        public Builder advancedOptions(UnifiedAgentTailSourceAdvancedOptions advancedOptions) {
            this.advancedOptions = advancedOptions;
            this.__explicitlySet__.add("advancedOptions");
            return this;
        }

        public UnifiedAgentTailLogSource build() {
            UnifiedAgentTailLogSource model = new UnifiedAgentTailLogSource(this.name, this.paths, this.parser, this.advancedOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentTailLogSource model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("paths")) {
                this.paths(model.getPaths());
            }
            if (model.wasPropertyExplicitlySet("parser")) {
                this.parser(model.getParser());
            }
            if (model.wasPropertyExplicitlySet("advancedOptions")) {
                this.advancedOptions(model.getAdvancedOptions());
            }
            return this;
        }
    }
}

