/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.logging.model.ChangeLogLogGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeLogLogGroupRequest
extends BmcRequest<ChangeLogLogGroupDetails> {
    private String logGroupId;
    private String logId;
    private ChangeLogLogGroupDetails changeLogLogGroupDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public String getLogId() {
        return this.logId;
    }

    public ChangeLogLogGroupDetails getChangeLogLogGroupDetails() {
        return this.changeLogLogGroupDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeLogLogGroupDetails getBody$() {
        return this.changeLogLogGroupDetails;
    }

    public Builder toBuilder() {
        return new Builder().logGroupId(this.logGroupId).logId(this.logId).changeLogLogGroupDetails(this.changeLogLogGroupDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(",logId=").append(String.valueOf(this.logId));
        sb.append(",changeLogLogGroupDetails=").append(String.valueOf((Object)this.changeLogLogGroupDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeLogLogGroupRequest)) {
            return false;
        }
        ChangeLogLogGroupRequest other = (ChangeLogLogGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals(this.logId, other.logId) && Objects.equals((Object)this.changeLogLogGroupDetails, (Object)other.changeLogLogGroupDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.logId == null ? 43 : this.logId.hashCode());
        result = result * 59 + (this.changeLogLogGroupDetails == null ? 43 : this.changeLogLogGroupDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeLogLogGroupRequest, ChangeLogLogGroupDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String logGroupId = null;
        private String logId = null;
        private ChangeLogLogGroupDetails changeLogLogGroupDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder logId(String logId) {
            this.logId = logId;
            return this;
        }

        public Builder changeLogLogGroupDetails(ChangeLogLogGroupDetails changeLogLogGroupDetails) {
            this.changeLogLogGroupDetails = changeLogLogGroupDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeLogLogGroupRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.logId(o.getLogId());
            this.changeLogLogGroupDetails(o.getChangeLogLogGroupDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeLogLogGroupRequest build() {
            ChangeLogLogGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeLogLogGroupDetails body) {
            this.changeLogLogGroupDetails(body);
            return this;
        }

        public ChangeLogLogGroupRequest buildWithoutInvocationCallback() {
            ChangeLogLogGroupRequest request = new ChangeLogLogGroupRequest();
            request.logGroupId = this.logGroupId;
            request.logId = this.logId;
            request.changeLogLogGroupDetails = this.changeLogLogGroupDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

