/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.logging.model.CreateLogDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateLogRequest
extends BmcRequest<CreateLogDetails> {
    private String logGroupId;
    private CreateLogDetails createLogDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public CreateLogDetails getCreateLogDetails() {
        return this.createLogDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateLogDetails getBody$() {
        return this.createLogDetails;
    }

    public Builder toBuilder() {
        return new Builder().logGroupId(this.logGroupId).createLogDetails(this.createLogDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(",createLogDetails=").append(String.valueOf((Object)this.createLogDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateLogRequest)) {
            return false;
        }
        CreateLogRequest other = (CreateLogRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals((Object)this.createLogDetails, (Object)other.createLogDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.createLogDetails == null ? 43 : this.createLogDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateLogRequest, CreateLogDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String logGroupId = null;
        private CreateLogDetails createLogDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder createLogDetails(CreateLogDetails createLogDetails) {
            this.createLogDetails = createLogDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateLogRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.createLogDetails(o.getCreateLogDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateLogRequest build() {
            CreateLogRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateLogDetails body) {
            this.createLogDetails(body);
            return this;
        }

        public CreateLogRequest buildWithoutInvocationCallback() {
            CreateLogRequest request = new CreateLogRequest();
            request.logGroupId = this.logGroupId;
            request.createLogDetails = this.createLogDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

