/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loggingingestion.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loggingingestion.model.LogEntry;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogEntryBatch
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entries")
    private final List<LogEntry> entries;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="subject")
    private final String subject;
    @JsonProperty(value="defaultlogentrytime")
    private final Date defaultlogentrytime;

    @Deprecated
    @ConstructorProperties(value={"entries", "source", "type", "subject", "defaultlogentrytime"})
    public LogEntryBatch(List<LogEntry> entries, String source, String type, String subject, Date defaultlogentrytime) {
        this.entries = entries;
        this.source = source;
        this.type = type;
        this.subject = subject;
        this.defaultlogentrytime = defaultlogentrytime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<LogEntry> getEntries() {
        return this.entries;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getDefaultlogentrytime() {
        return this.defaultlogentrytime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogEntryBatch(");
        sb.append("super=").append(super.toString());
        sb.append("entries=").append(String.valueOf(this.entries));
        sb.append(", source=").append(String.valueOf(this.source));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", subject=").append(String.valueOf(this.subject));
        sb.append(", defaultlogentrytime=").append(String.valueOf(this.defaultlogentrytime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogEntryBatch)) {
            return false;
        }
        LogEntryBatch other = (LogEntryBatch)((Object)o);
        return Objects.equals(this.entries, other.entries) && Objects.equals(this.source, other.source) && Objects.equals(this.type, other.type) && Objects.equals(this.subject, other.subject) && Objects.equals(this.defaultlogentrytime, other.defaultlogentrytime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entries == null ? 43 : this.entries.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.subject == null ? 43 : this.subject.hashCode());
        result = result * 59 + (this.defaultlogentrytime == null ? 43 : this.defaultlogentrytime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entries")
        private List<LogEntry> entries;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="subject")
        private String subject;
        @JsonProperty(value="defaultlogentrytime")
        private Date defaultlogentrytime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entries(List<LogEntry> entries) {
            this.entries = entries;
            this.__explicitlySet__.add("entries");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.__explicitlySet__.add("subject");
            return this;
        }

        public Builder defaultlogentrytime(Date defaultlogentrytime) {
            this.defaultlogentrytime = defaultlogentrytime;
            this.__explicitlySet__.add("defaultlogentrytime");
            return this;
        }

        public LogEntryBatch build() {
            LogEntryBatch model = new LogEntryBatch(this.entries, this.source, this.type, this.subject, this.defaultlogentrytime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogEntryBatch model) {
            if (model.wasPropertyExplicitlySet("entries")) {
                this.entries(model.getEntries());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("subject")) {
                this.subject(model.getSubject());
            }
            if (model.wasPropertyExplicitlySet("defaultlogentrytime")) {
                this.defaultlogentrytime(model.getDefaultlogentrytime());
            }
            return this;
        }
    }
}

