/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loggingingestion.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loggingingestion.model.PutLogsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class PutLogsRequest
extends BmcRequest<PutLogsDetails> {
    private String logId;
    private PutLogsDetails putLogsDetails;
    private Date timestampOpcAgentProcessing;
    private String opcAgentVersion;
    private String opcRequestId;

    public String getLogId() {
        return this.logId;
    }

    public PutLogsDetails getPutLogsDetails() {
        return this.putLogsDetails;
    }

    public Date getTimestampOpcAgentProcessing() {
        return this.timestampOpcAgentProcessing;
    }

    public String getOpcAgentVersion() {
        return this.opcAgentVersion;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PutLogsDetails getBody$() {
        return this.putLogsDetails;
    }

    public Builder toBuilder() {
        return new Builder().logId(this.logId).putLogsDetails(this.putLogsDetails).timestampOpcAgentProcessing(this.timestampOpcAgentProcessing).opcAgentVersion(this.opcAgentVersion).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",logId=").append(String.valueOf(this.logId));
        sb.append(",putLogsDetails=").append(String.valueOf((Object)this.putLogsDetails));
        sb.append(",timestampOpcAgentProcessing=").append(String.valueOf(this.timestampOpcAgentProcessing));
        sb.append(",opcAgentVersion=").append(String.valueOf(this.opcAgentVersion));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutLogsRequest)) {
            return false;
        }
        PutLogsRequest other = (PutLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.logId, other.logId) && Objects.equals((Object)this.putLogsDetails, (Object)other.putLogsDetails) && Objects.equals(this.timestampOpcAgentProcessing, other.timestampOpcAgentProcessing) && Objects.equals(this.opcAgentVersion, other.opcAgentVersion) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.logId == null ? 43 : this.logId.hashCode());
        result = result * 59 + (this.putLogsDetails == null ? 43 : this.putLogsDetails.hashCode());
        result = result * 59 + (this.timestampOpcAgentProcessing == null ? 43 : this.timestampOpcAgentProcessing.hashCode());
        result = result * 59 + (this.opcAgentVersion == null ? 43 : this.opcAgentVersion.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PutLogsRequest, PutLogsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String logId = null;
        private PutLogsDetails putLogsDetails = null;
        private Date timestampOpcAgentProcessing = null;
        private String opcAgentVersion = null;
        private String opcRequestId = null;

        public Builder logId(String logId) {
            this.logId = logId;
            return this;
        }

        public Builder putLogsDetails(PutLogsDetails putLogsDetails) {
            this.putLogsDetails = putLogsDetails;
            return this;
        }

        public Builder timestampOpcAgentProcessing(Date timestampOpcAgentProcessing) {
            this.timestampOpcAgentProcessing = timestampOpcAgentProcessing;
            return this;
        }

        public Builder opcAgentVersion(String opcAgentVersion) {
            this.opcAgentVersion = opcAgentVersion;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutLogsRequest o) {
            this.logId(o.getLogId());
            this.putLogsDetails(o.getPutLogsDetails());
            this.timestampOpcAgentProcessing(o.getTimestampOpcAgentProcessing());
            this.opcAgentVersion(o.getOpcAgentVersion());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutLogsRequest build() {
            PutLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PutLogsDetails body) {
            this.putLogsDetails(body);
            return this;
        }

        public PutLogsRequest buildWithoutInvocationCallback() {
            PutLogsRequest request = new PutLogsRequest();
            request.logId = this.logId;
            request.putLogsDetails = this.putLogsDetails;
            request.timestampOpcAgentProcessing = this.timestampOpcAgentProcessing;
            request.opcAgentVersion = this.opcAgentVersion;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

