/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loggingsearch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loggingsearch.model.FieldInfo;
import com.oracle.bmc.loggingsearch.model.SearchResult;
import com.oracle.bmc.loggingsearch.model.SearchResultSummary;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SearchResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="results")
    private final List<SearchResult> results;
    @JsonProperty(value="fields")
    private final List<FieldInfo> fields;
    @JsonProperty(value="summary")
    private final SearchResultSummary summary;

    @Deprecated
    @ConstructorProperties(value={"results", "fields", "summary"})
    public SearchResponse(List<SearchResult> results, List<FieldInfo> fields, SearchResultSummary summary) {
        this.results = results;
        this.fields = fields;
        this.summary = summary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public SearchResultSummary getSummary() {
        return this.summary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchResponse(");
        sb.append("super=").append(super.toString());
        sb.append("results=").append(String.valueOf(this.results));
        sb.append(", fields=").append(String.valueOf(this.fields));
        sb.append(", summary=").append(String.valueOf((Object)this.summary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse)((Object)o);
        return Objects.equals(this.results, other.results) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.summary, (Object)other.summary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.results == null ? 43 : this.results.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="results")
        private List<SearchResult> results;
        @JsonProperty(value="fields")
        private List<FieldInfo> fields;
        @JsonProperty(value="summary")
        private SearchResultSummary summary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder results(List<SearchResult> results) {
            this.results = results;
            this.__explicitlySet__.add("results");
            return this;
        }

        public Builder fields(List<FieldInfo> fields) {
            this.fields = fields;
            this.__explicitlySet__.add("fields");
            return this;
        }

        public Builder summary(SearchResultSummary summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public SearchResponse build() {
            SearchResponse model = new SearchResponse(this.results, this.fields, this.summary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SearchResponse model) {
            if (model.wasPropertyExplicitlySet("results")) {
                this.results(model.getResults());
            }
            if (model.wasPropertyExplicitlySet("fields")) {
                this.fields(model.getFields());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            return this;
        }
    }
}

