/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.managementdashboard.DashxApisAsync;
import com.oracle.bmc.managementdashboard.internal.http.ChangeManagementDashboardsCompartmentConverter;
import com.oracle.bmc.managementdashboard.internal.http.ChangeManagementSavedSearchesCompartmentConverter;
import com.oracle.bmc.managementdashboard.internal.http.CreateManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.CreateManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.internal.http.DeleteManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.DeleteManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.internal.http.ExportDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.GetManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.GetManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.internal.http.ImportDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.ListManagementDashboardsConverter;
import com.oracle.bmc.managementdashboard.internal.http.ListManagementSavedSearchesConverter;
import com.oracle.bmc.managementdashboard.internal.http.UpdateManagementDashboardConverter;
import com.oracle.bmc.managementdashboard.internal.http.UpdateManagementSavedSearchConverter;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementDashboardsCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementSavedSearchesCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ExportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ImportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementDashboardsRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementSavedSearchesRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementDashboardsCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementSavedSearchesCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ExportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ImportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementDashboardsResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementSavedSearchesResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementSavedSearchResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashxApisAsyncClient
implements DashxApisAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DashxApisAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DASHXAPIS").serviceEndpointPrefix("").serviceEndpointTemplate("https://managementdashboard.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DashxApisAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DashxApisAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DashxApisAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeManagementDashboardsCompartmentResponse> changeManagementDashboardsCompartment(ChangeManagementDashboardsCompartmentRequest request, AsyncHandler<ChangeManagementDashboardsCompartmentRequest, ChangeManagementDashboardsCompartmentResponse> handler) {
        LOG.trace("Called async changeManagementDashboardsCompartment");
        ChangeManagementDashboardsCompartmentRequest interceptedRequest = ChangeManagementDashboardsCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagementDashboardsCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagementDashboardsCompartmentResponse> transformer = ChangeManagementDashboardsCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeManagementDashboardsCompartmentRequest, ChangeManagementDashboardsCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeManagementDashboardsCompartmentRequest, ChangeManagementDashboardsCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeManagementSavedSearchesCompartmentResponse> changeManagementSavedSearchesCompartment(ChangeManagementSavedSearchesCompartmentRequest request, AsyncHandler<ChangeManagementSavedSearchesCompartmentRequest, ChangeManagementSavedSearchesCompartmentResponse> handler) {
        LOG.trace("Called async changeManagementSavedSearchesCompartment");
        ChangeManagementSavedSearchesCompartmentRequest interceptedRequest = ChangeManagementSavedSearchesCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagementSavedSearchesCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagementSavedSearchesCompartmentResponse> transformer = ChangeManagementSavedSearchesCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeManagementSavedSearchesCompartmentRequest, ChangeManagementSavedSearchesCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeManagementSavedSearchesCompartmentRequest, ChangeManagementSavedSearchesCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateManagementDashboardResponse> createManagementDashboard(CreateManagementDashboardRequest request, AsyncHandler<CreateManagementDashboardRequest, CreateManagementDashboardResponse> handler) {
        LOG.trace("Called async createManagementDashboard");
        CreateManagementDashboardRequest interceptedRequest = CreateManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagementDashboardResponse> transformer = CreateManagementDashboardConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateManagementDashboardRequest, CreateManagementDashboardResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateManagementDashboardRequest, CreateManagementDashboardResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateManagementSavedSearchResponse> createManagementSavedSearch(CreateManagementSavedSearchRequest request, AsyncHandler<CreateManagementSavedSearchRequest, CreateManagementSavedSearchResponse> handler) {
        LOG.trace("Called async createManagementSavedSearch");
        CreateManagementSavedSearchRequest interceptedRequest = CreateManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagementSavedSearchResponse> transformer = CreateManagementSavedSearchConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateManagementSavedSearchRequest, CreateManagementSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateManagementSavedSearchRequest, CreateManagementSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteManagementDashboardResponse> deleteManagementDashboard(DeleteManagementDashboardRequest request, AsyncHandler<DeleteManagementDashboardRequest, DeleteManagementDashboardResponse> handler) {
        LOG.trace("Called async deleteManagementDashboard");
        DeleteManagementDashboardRequest interceptedRequest = DeleteManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagementDashboardResponse> transformer = DeleteManagementDashboardConverter.fromResponse();
        AsyncHandler<DeleteManagementDashboardRequest, DeleteManagementDashboardResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteManagementDashboardRequest, DeleteManagementDashboardResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteManagementSavedSearchResponse> deleteManagementSavedSearch(DeleteManagementSavedSearchRequest request, AsyncHandler<DeleteManagementSavedSearchRequest, DeleteManagementSavedSearchResponse> handler) {
        LOG.trace("Called async deleteManagementSavedSearch");
        DeleteManagementSavedSearchRequest interceptedRequest = DeleteManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagementSavedSearchResponse> transformer = DeleteManagementSavedSearchConverter.fromResponse();
        AsyncHandler<DeleteManagementSavedSearchRequest, DeleteManagementSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteManagementSavedSearchRequest, DeleteManagementSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExportDashboardResponse> exportDashboard(ExportDashboardRequest request, AsyncHandler<ExportDashboardRequest, ExportDashboardResponse> handler) {
        LOG.trace("Called async exportDashboard");
        ExportDashboardRequest interceptedRequest = ExportDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExportDashboardResponse> transformer = ExportDashboardConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExportDashboardRequest, ExportDashboardResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExportDashboardRequest, ExportDashboardResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagementDashboardResponse> getManagementDashboard(GetManagementDashboardRequest request, AsyncHandler<GetManagementDashboardRequest, GetManagementDashboardResponse> handler) {
        LOG.trace("Called async getManagementDashboard");
        GetManagementDashboardRequest interceptedRequest = GetManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagementDashboardResponse> transformer = GetManagementDashboardConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GetManagementDashboardRequest, GetManagementDashboardResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagementDashboardRequest, GetManagementDashboardResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagementSavedSearchResponse> getManagementSavedSearch(GetManagementSavedSearchRequest request, AsyncHandler<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> handler) {
        LOG.trace("Called async getManagementSavedSearch");
        GetManagementSavedSearchRequest interceptedRequest = GetManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagementSavedSearchResponse> transformer = GetManagementSavedSearchConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ImportDashboardResponse> importDashboard(ImportDashboardRequest request, AsyncHandler<ImportDashboardRequest, ImportDashboardResponse> handler) {
        LOG.trace("Called async importDashboard");
        ImportDashboardRequest interceptedRequest = ImportDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportDashboardResponse> transformer = ImportDashboardConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ImportDashboardRequest, ImportDashboardResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ImportDashboardRequest, ImportDashboardResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagementDashboardsResponse> listManagementDashboards(ListManagementDashboardsRequest request, AsyncHandler<ListManagementDashboardsRequest, ListManagementDashboardsResponse> handler) {
        LOG.trace("Called async listManagementDashboards");
        ListManagementDashboardsRequest interceptedRequest = ListManagementDashboardsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagementDashboardsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagementDashboardsResponse> transformer = ListManagementDashboardsConverter.fromResponse();
        AsyncHandler<ListManagementDashboardsRequest, ListManagementDashboardsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagementDashboardsRequest, ListManagementDashboardsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagementSavedSearchesResponse> listManagementSavedSearches(ListManagementSavedSearchesRequest request, AsyncHandler<ListManagementSavedSearchesRequest, ListManagementSavedSearchesResponse> handler) {
        LOG.trace("Called async listManagementSavedSearches");
        ListManagementSavedSearchesRequest interceptedRequest = ListManagementSavedSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagementSavedSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagementSavedSearchesResponse> transformer = ListManagementSavedSearchesConverter.fromResponse();
        AsyncHandler<ListManagementSavedSearchesRequest, ListManagementSavedSearchesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagementSavedSearchesRequest, ListManagementSavedSearchesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateManagementDashboardResponse> updateManagementDashboard(UpdateManagementDashboardRequest request, AsyncHandler<UpdateManagementDashboardRequest, UpdateManagementDashboardResponse> handler) {
        LOG.trace("Called async updateManagementDashboard");
        UpdateManagementDashboardRequest interceptedRequest = UpdateManagementDashboardConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagementDashboardConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagementDashboardResponse> transformer = UpdateManagementDashboardConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateManagementDashboardRequest, UpdateManagementDashboardResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateManagementDashboardRequest, UpdateManagementDashboardResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateManagementSavedSearchResponse> updateManagementSavedSearch(UpdateManagementSavedSearchRequest request, AsyncHandler<UpdateManagementSavedSearchRequest, UpdateManagementSavedSearchResponse> handler) {
        LOG.trace("Called async updateManagementSavedSearch");
        UpdateManagementSavedSearchRequest interceptedRequest = UpdateManagementSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagementSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagementSavedSearchResponse> transformer = UpdateManagementSavedSearchConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateManagementSavedSearchRequest, UpdateManagementSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateManagementSavedSearchRequest, UpdateManagementSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DashxApisAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DashxApisAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DashxApisAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

