/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ExportDashboardRequest
extends BmcRequest<Void> {
    private String exportDashboardId;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"exportDashboardId", "opcRetryToken", "opcRequestId"})
    ExportDashboardRequest(String exportDashboardId, String opcRetryToken, String opcRequestId) {
        this.exportDashboardId = exportDashboardId;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getExportDashboardId() {
        return this.exportDashboardId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportDashboardRequest, Void> {
        private String exportDashboardId;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportDashboardRequest o) {
            this.exportDashboardId(o.getExportDashboardId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportDashboardRequest build() {
            ExportDashboardRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder exportDashboardId(String exportDashboardId) {
            this.exportDashboardId = exportDashboardId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ExportDashboardRequest buildWithoutInvocationCallback() {
            return new ExportDashboardRequest(this.exportDashboardId, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "ExportDashboardRequest.Builder(exportDashboardId=" + this.exportDashboardId + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

