/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.managementdashboard.DashxApisAsync;
import com.oracle.bmc.managementdashboard.model.ManagementDashboard;
import com.oracle.bmc.managementdashboard.model.ManagementDashboardCollection;
import com.oracle.bmc.managementdashboard.model.ManagementDashboardExportDetails;
import com.oracle.bmc.managementdashboard.model.ManagementSavedSearch;
import com.oracle.bmc.managementdashboard.model.ManagementSavedSearchCollection;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementDashboardsCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.ChangeManagementSavedSearchesCompartmentRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.CreateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.DeleteManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ExportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.GetManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.requests.ImportDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementDashboardsRequest;
import com.oracle.bmc.managementdashboard.requests.ListManagementSavedSearchesRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementDashboardRequest;
import com.oracle.bmc.managementdashboard.requests.UpdateManagementSavedSearchRequest;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementDashboardsCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.ChangeManagementSavedSearchesCompartmentResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.CreateManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.DeleteManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ExportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.GetManagementSavedSearchResponse;
import com.oracle.bmc.managementdashboard.responses.ImportDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementDashboardsResponse;
import com.oracle.bmc.managementdashboard.responses.ListManagementSavedSearchesResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementDashboardResponse;
import com.oracle.bmc.managementdashboard.responses.UpdateManagementSavedSearchResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashxApisAsyncClient
extends BaseAsyncClient
implements DashxApisAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DASHXAPIS").serviceEndpointPrefix("").serviceEndpointTemplate("https://managementdashboard.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DashxApisAsyncClient.class);

    DashxApisAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeManagementDashboardsCompartmentResponse> changeManagementDashboardsCompartment(ChangeManagementDashboardsCompartmentRequest request, AsyncHandler<ChangeManagementDashboardsCompartmentRequest, ChangeManagementDashboardsCompartmentResponse> handler) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagementDashboardsCompartmentDetails(), "changeManagementDashboardsCompartmentDetails is required");
        return this.clientCall(request, ChangeManagementDashboardsCompartmentResponse::builder).logger(LOG, "changeManagementDashboardsCompartment").serviceDetails("DashxApis", "ChangeManagementDashboardsCompartment", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/ChangeManagementDashboardsCompartment").method(Method.POST).requestBuilder(ChangeManagementDashboardsCompartmentRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementDashboard.class, ChangeManagementDashboardsCompartmentResponse.Builder::managementDashboard).handleResponseHeaderString("etag", ChangeManagementDashboardsCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeManagementDashboardsCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeManagementDashboardsCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeManagementSavedSearchesCompartmentResponse> changeManagementSavedSearchesCompartment(ChangeManagementSavedSearchesCompartmentRequest request, AsyncHandler<ChangeManagementSavedSearchesCompartmentRequest, ChangeManagementSavedSearchesCompartmentResponse> handler) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagementSavedSearchesCompartmentDetails(), "changeManagementSavedSearchesCompartmentDetails is required");
        return this.clientCall(request, ChangeManagementSavedSearchesCompartmentResponse::builder).logger(LOG, "changeManagementSavedSearchesCompartment").serviceDetails("DashxApis", "ChangeManagementSavedSearchesCompartment", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/ChangeManagementSavedSearchesCompartment").method(Method.POST).requestBuilder(ChangeManagementSavedSearchesCompartmentRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementSavedSearch.class, ChangeManagementSavedSearchesCompartmentResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", ChangeManagementSavedSearchesCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeManagementSavedSearchesCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeManagementSavedSearchesCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateManagementDashboardResponse> createManagementDashboard(CreateManagementDashboardRequest request, AsyncHandler<CreateManagementDashboardRequest, CreateManagementDashboardResponse> handler) {
        Objects.requireNonNull(request.getCreateManagementDashboardDetails(), "createManagementDashboardDetails is required");
        return this.clientCall(request, CreateManagementDashboardResponse::builder).logger(LOG, "createManagementDashboard").serviceDetails("DashxApis", "CreateManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/CreateManagementDashboard").method(Method.POST).requestBuilder(CreateManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementDashboard.class, CreateManagementDashboardResponse.Builder::managementDashboard).handleResponseHeaderString("etag", CreateManagementDashboardResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateManagementDashboardResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateManagementSavedSearchResponse> createManagementSavedSearch(CreateManagementSavedSearchRequest request, AsyncHandler<CreateManagementSavedSearchRequest, CreateManagementSavedSearchResponse> handler) {
        Objects.requireNonNull(request.getCreateManagementSavedSearchDetails(), "createManagementSavedSearchDetails is required");
        return this.clientCall(request, CreateManagementSavedSearchResponse::builder).logger(LOG, "createManagementSavedSearch").serviceDetails("DashxApis", "CreateManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/CreateManagementSavedSearch").method(Method.POST).requestBuilder(CreateManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementSavedSearch.class, CreateManagementSavedSearchResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", CreateManagementSavedSearchResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateManagementSavedSearchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteManagementDashboardResponse> deleteManagementDashboard(DeleteManagementDashboardRequest request, AsyncHandler<DeleteManagementDashboardRequest, DeleteManagementDashboardResponse> handler) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteManagementDashboardResponse::builder).logger(LOG, "deleteManagementDashboard").serviceDetails("DashxApis", "DeleteManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/DeleteManagementDashboard").method(Method.DELETE).requestBuilder(DeleteManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteManagementDashboardResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteManagementSavedSearchResponse> deleteManagementSavedSearch(DeleteManagementSavedSearchRequest request, AsyncHandler<DeleteManagementSavedSearchRequest, DeleteManagementSavedSearchResponse> handler) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteManagementSavedSearchResponse::builder).logger(LOG, "deleteManagementSavedSearch").serviceDetails("DashxApis", "DeleteManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/DeleteManagementSavedSearch").method(Method.DELETE).requestBuilder(DeleteManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteManagementSavedSearchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ExportDashboardResponse> exportDashboard(ExportDashboardRequest request, AsyncHandler<ExportDashboardRequest, ExportDashboardResponse> handler) {
        Validate.notBlank((String)request.getExportDashboardId(), (String)"exportDashboardId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ExportDashboardResponse::builder).logger(LOG, "exportDashboard").serviceDetails("DashxApis", "ExportDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboardImportDetails/ExportDashboard").method(Method.GET).requestBuilder(ExportDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam("actions").appendPathParam("exportDashboard").appendPathParam(request.getExportDashboardId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementDashboardExportDetails.class, ExportDashboardResponse.Builder::managementDashboardExportDetails).handleResponseHeaderString("opc-work-request-id", ExportDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ExportDashboardResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagementDashboardResponse> getManagementDashboard(GetManagementDashboardRequest request, AsyncHandler<GetManagementDashboardRequest, GetManagementDashboardResponse> handler) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagementDashboardResponse::builder).logger(LOG, "getManagementDashboard").serviceDetails("DashxApis", "GetManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/GetManagementDashboard").method(Method.GET).requestBuilder(GetManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementDashboard.class, GetManagementDashboardResponse.Builder::managementDashboard).handleResponseHeaderString("etag", GetManagementDashboardResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", GetManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GetManagementDashboardResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagementSavedSearchResponse> getManagementSavedSearch(GetManagementSavedSearchRequest request, AsyncHandler<GetManagementSavedSearchRequest, GetManagementSavedSearchResponse> handler) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagementSavedSearchResponse::builder).logger(LOG, "getManagementSavedSearch").serviceDetails("DashxApis", "GetManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/GetManagementSavedSearch").method(Method.GET).requestBuilder(GetManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementSavedSearch.class, GetManagementSavedSearchResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", GetManagementSavedSearchResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", GetManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GetManagementSavedSearchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ImportDashboardResponse> importDashboard(ImportDashboardRequest request, AsyncHandler<ImportDashboardRequest, ImportDashboardResponse> handler) {
        Objects.requireNonNull(request.getManagementDashboardImportDetails(), "managementDashboardImportDetails is required");
        return this.clientCall(request, ImportDashboardResponse::builder).logger(LOG, "importDashboard").serviceDetails("DashxApis", "ImportDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboardImportDetails/ImportDashboard").method(Method.POST).requestBuilder(ImportDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam("actions").appendPathParam("importDashboard").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ImportDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportDashboardResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListManagementDashboardsResponse> listManagementDashboards(ListManagementDashboardsRequest request, AsyncHandler<ListManagementDashboardsRequest, ListManagementDashboardsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagementDashboardsResponse::builder).logger(LOG, "listManagementDashboards").serviceDetails("DashxApis", "ListManagementDashboards", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/ListManagementDashboards").method(Method.GET).requestBuilder(ListManagementDashboardsRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementDashboardCollection.class, ListManagementDashboardsResponse.Builder::managementDashboardCollection).handleResponseHeaderString("opc-request-id", ListManagementDashboardsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagementDashboardsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagementSavedSearchesResponse> listManagementSavedSearches(ListManagementSavedSearchesRequest request, AsyncHandler<ListManagementSavedSearchesRequest, ListManagementSavedSearchesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagementSavedSearchesResponse::builder).logger(LOG, "listManagementSavedSearches").serviceDetails("DashxApis", "ListManagementSavedSearches", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/ListManagementSavedSearches").method(Method.GET).requestBuilder(ListManagementSavedSearchesRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagementSavedSearchCollection.class, ListManagementSavedSearchesResponse.Builder::managementSavedSearchCollection).handleResponseHeaderString("opc-request-id", ListManagementSavedSearchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagementSavedSearchesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateManagementDashboardResponse> updateManagementDashboard(UpdateManagementDashboardRequest request, AsyncHandler<UpdateManagementDashboardRequest, UpdateManagementDashboardResponse> handler) {
        Validate.notBlank((String)request.getManagementDashboardId(), (String)"managementDashboardId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagementDashboardDetails(), "updateManagementDashboardDetails is required");
        return this.clientCall(request, UpdateManagementDashboardResponse::builder).logger(LOG, "updateManagementDashboard").serviceDetails("DashxApis", "UpdateManagementDashboard", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementDashboard/UpdateManagementDashboard").method(Method.PUT).requestBuilder(UpdateManagementDashboardRequest::builder).basePath("/20200901").appendPathParam("managementDashboards").appendPathParam(request.getManagementDashboardId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementDashboard.class, UpdateManagementDashboardResponse.Builder::managementDashboard).handleResponseHeaderString("etag", UpdateManagementDashboardResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateManagementDashboardResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateManagementDashboardResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateManagementSavedSearchResponse> updateManagementSavedSearch(UpdateManagementSavedSearchRequest request, AsyncHandler<UpdateManagementSavedSearchRequest, UpdateManagementSavedSearchResponse> handler) {
        Validate.notBlank((String)request.getManagementSavedSearchId(), (String)"managementSavedSearchId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagementSavedSearchDetails(), "updateManagementSavedSearchDetails is required");
        return this.clientCall(request, UpdateManagementSavedSearchResponse::builder).logger(LOG, "updateManagementSavedSearch").serviceDetails("DashxApis", "UpdateManagementSavedSearch", "https://docs.oracle.com/iaas/api/#/en/managementdashboard/20200901/ManagementSavedSearch/UpdateManagementSavedSearch").method(Method.PUT).requestBuilder(UpdateManagementSavedSearchRequest::builder).basePath("/20200901").appendPathParam("managementSavedSearches").appendPathParam(request.getManagementSavedSearchId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagementSavedSearch.class, UpdateManagementSavedSearchResponse.Builder::managementSavedSearch).handleResponseHeaderString("etag", UpdateManagementSavedSearchResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateManagementSavedSearchResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateManagementSavedSearchResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DashxApisAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DashxApisAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DashxApisAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DashxApisAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DashxApisAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DashxApisAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DashxApisAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DashxApisAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DashxApisAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DashxApisAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DashxApisAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DashxApisAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "managementdashboard";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"managementdashboard");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DashxApisAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DashxApisAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

