/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mysql.ChannelsAsync;
import com.oracle.bmc.mysql.model.Channel;
import com.oracle.bmc.mysql.model.ChannelSummary;
import com.oracle.bmc.mysql.requests.CreateChannelRequest;
import com.oracle.bmc.mysql.requests.DeleteChannelRequest;
import com.oracle.bmc.mysql.requests.GetChannelRequest;
import com.oracle.bmc.mysql.requests.ListChannelsRequest;
import com.oracle.bmc.mysql.requests.ResetChannelRequest;
import com.oracle.bmc.mysql.requests.ResumeChannelRequest;
import com.oracle.bmc.mysql.requests.UpdateChannelRequest;
import com.oracle.bmc.mysql.responses.CreateChannelResponse;
import com.oracle.bmc.mysql.responses.DeleteChannelResponse;
import com.oracle.bmc.mysql.responses.GetChannelResponse;
import com.oracle.bmc.mysql.responses.ListChannelsResponse;
import com.oracle.bmc.mysql.responses.ResetChannelResponse;
import com.oracle.bmc.mysql.responses.ResumeChannelResponse;
import com.oracle.bmc.mysql.responses.UpdateChannelResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelsAsyncClient
extends BaseAsyncClient
implements ChannelsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CHANNELS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ChannelsAsyncClient.class);

    ChannelsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateChannelResponse> createChannel(CreateChannelRequest request, AsyncHandler<CreateChannelRequest, CreateChannelResponse> handler) {
        Objects.requireNonNull(request.getCreateChannelDetails(), "createChannelDetails is required");
        return this.clientCall(request, CreateChannelResponse::builder).logger(LOG, "createChannel").serviceDetails("Channels", "CreateChannel", "").method(Method.POST).requestBuilder(CreateChannelRequest::builder).basePath("/20190415").appendPathParam("channels").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Channel.class, CreateChannelResponse.Builder::channel).handleResponseHeaderString("etag", CreateChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteChannelResponse> deleteChannel(DeleteChannelRequest request, AsyncHandler<DeleteChannelRequest, DeleteChannelResponse> handler) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteChannelResponse::builder).logger(LOG, "deleteChannel").serviceDetails("Channels", "DeleteChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/DeleteChannel").method(Method.DELETE).requestBuilder(DeleteChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetChannelResponse> getChannel(GetChannelRequest request, AsyncHandler<GetChannelRequest, GetChannelResponse> handler) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetChannelResponse::builder).logger(LOG, "getChannel").serviceDetails("Channels", "GetChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/GetChannel").method(Method.GET).requestBuilder(GetChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Channel.class, GetChannelResponse.Builder::channel).handleResponseHeaderString("etag", GetChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListChannelsResponse> listChannels(ListChannelsRequest request, AsyncHandler<ListChannelsRequest, ListChannelsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListChannelsResponse::builder).logger(LOG, "listChannels").serviceDetails("Channels", "ListChannels", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/ChannelSummary/ListChannels").method(Method.GET).requestBuilder(ListChannelsRequest::builder).basePath("/20190415").appendPathParam("channels").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("channelId", (Object)request.getChannelId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("isEnabled", (Object)request.getIsEnabled()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ChannelSummary.class, ListChannelsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListChannelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListChannelsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ResetChannelResponse> resetChannel(ResetChannelRequest request, AsyncHandler<ResetChannelRequest, ResetChannelResponse> handler) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResetChannelResponse::builder).logger(LOG, "resetChannel").serviceDetails("Channels", "ResetChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/ResetChannel").method(Method.POST).requestBuilder(ResetChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("reset").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", ResetChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ResetChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ResumeChannelResponse> resumeChannel(ResumeChannelRequest request, AsyncHandler<ResumeChannelRequest, ResumeChannelResponse> handler) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResumeChannelResponse::builder).logger(LOG, "resumeChannel").serviceDetails("Channels", "ResumeChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/ResumeChannel").method(Method.POST).requestBuilder(ResumeChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", ResumeChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ResumeChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateChannelResponse> updateChannel(UpdateChannelRequest request, AsyncHandler<UpdateChannelRequest, UpdateChannelResponse> handler) {
        Validate.notBlank((String)request.getChannelId(), (String)"channelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateChannelDetails(), "updateChannelDetails is required");
        return this.clientCall(request, UpdateChannelResponse::builder).logger(LOG, "updateChannel").serviceDetails("Channels", "UpdateChannel", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Channel/UpdateChannel").method(Method.PUT).requestBuilder(UpdateChannelRequest::builder).basePath("/20190415").appendPathParam("channels").appendPathParam(request.getChannelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public ChannelsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ChannelsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ChannelsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ChannelsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ChannelsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ChannelsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ChannelsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ChannelsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ChannelsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ChannelsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ChannelsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ChannelsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ChannelsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ChannelsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ChannelsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ChannelsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ChannelsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

