/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mysql.DbBackupsAsync;
import com.oracle.bmc.mysql.model.Backup;
import com.oracle.bmc.mysql.model.BackupSummary;
import com.oracle.bmc.mysql.requests.ChangeBackupCompartmentRequest;
import com.oracle.bmc.mysql.requests.CreateBackupRequest;
import com.oracle.bmc.mysql.requests.DeleteBackupRequest;
import com.oracle.bmc.mysql.requests.GetBackupRequest;
import com.oracle.bmc.mysql.requests.ListBackupsRequest;
import com.oracle.bmc.mysql.requests.UpdateBackupRequest;
import com.oracle.bmc.mysql.responses.ChangeBackupCompartmentResponse;
import com.oracle.bmc.mysql.responses.CreateBackupResponse;
import com.oracle.bmc.mysql.responses.DeleteBackupResponse;
import com.oracle.bmc.mysql.responses.GetBackupResponse;
import com.oracle.bmc.mysql.responses.ListBackupsResponse;
import com.oracle.bmc.mysql.responses.UpdateBackupResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbBackupsAsyncClient
extends BaseAsyncClient
implements DbBackupsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBBACKUPS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbBackupsAsyncClient.class);

    DbBackupsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeBackupCompartmentResponse> changeBackupCompartment(ChangeBackupCompartmentRequest request, AsyncHandler<ChangeBackupCompartmentRequest, ChangeBackupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBackupCompartmentDetails(), "changeBackupCompartmentDetails is required");
        return this.clientCall(request, ChangeBackupCompartmentResponse::builder).logger(LOG, "changeBackupCompartment").serviceDetails("DbBackups", "ChangeBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/ChangeBackupCompartment").method(Method.POST).requestBuilder(ChangeBackupCompartmentRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeBackupCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeBackupCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBackupResponse> createBackup(CreateBackupRequest request, AsyncHandler<CreateBackupRequest, CreateBackupResponse> handler) {
        Objects.requireNonNull(request.getCreateBackupDetails(), "createBackupDetails is required");
        return this.clientCall(request, CreateBackupResponse::builder).logger(LOG, "createBackup").serviceDetails("DbBackups", "CreateBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/CreateBackup").method(Method.POST).requestBuilder(CreateBackupRequest::builder).basePath("/20190415").appendPathParam("backups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Backup.class, CreateBackupResponse.Builder::backup).handleResponseHeaderString("etag", CreateBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateBackupResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateBackupResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBackupResponse> deleteBackup(DeleteBackupRequest request, AsyncHandler<DeleteBackupRequest, DeleteBackupResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBackupResponse::builder).logger(LOG, "deleteBackup").serviceDetails("DbBackups", "DeleteBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/DeleteBackup").method(Method.DELETE).requestBuilder(DeleteBackupRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteBackupResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteBackupResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBackupResponse> getBackup(GetBackupRequest request, AsyncHandler<GetBackupRequest, GetBackupResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBackupResponse::builder).logger(LOG, "getBackup").serviceDetails("DbBackups", "GetBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/GetBackup").method(Method.GET).requestBuilder(GetBackupRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Backup.class, GetBackupResponse.Builder::backup).handleResponseHeaderString("etag", GetBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBackupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListBackupsResponse> listBackups(ListBackupsRequest request, AsyncHandler<ListBackupsRequest, ListBackupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListBackupsResponse::builder).logger(LOG, "listBackups").serviceDetails("DbBackups", "ListBackups", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/BackupSummary/ListBackups").method(Method.GET).requestBuilder(ListBackupsRequest::builder).basePath("/20190415").appendPathParam("backups").appendQueryParam("backupId", (Object)request.getBackupId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("creationType", (BmcEnum)request.getCreationType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BackupSummary.class, ListBackupsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBackupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBackupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateBackupResponse> updateBackup(UpdateBackupRequest request, AsyncHandler<UpdateBackupRequest, UpdateBackupResponse> handler) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBackupDetails(), "updateBackupDetails is required");
        return this.clientCall(request, UpdateBackupResponse::builder).logger(LOG, "updateBackup").serviceDetails("DbBackups", "UpdateBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/UpdateBackup").method(Method.PUT).requestBuilder(UpdateBackupRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Backup.class, UpdateBackupResponse.Builder::backup).handleResponseHeaderString("opc-request-id", UpdateBackupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateBackupResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public DbBackupsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbBackupsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbBackupsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbBackupsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbBackupsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbBackupsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbBackupsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbBackupsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DbBackupsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbBackupsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DbBackupsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbBackupsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DbBackupsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbBackupsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbBackupsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DbBackupsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbBackupsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

