/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.mysql.DbBackups;
import com.oracle.bmc.mysql.DbBackupsPaginators;
import com.oracle.bmc.mysql.DbBackupsWaiters;
import com.oracle.bmc.mysql.model.Backup;
import com.oracle.bmc.mysql.model.BackupSummary;
import com.oracle.bmc.mysql.requests.ChangeBackupCompartmentRequest;
import com.oracle.bmc.mysql.requests.CreateBackupRequest;
import com.oracle.bmc.mysql.requests.DeleteBackupRequest;
import com.oracle.bmc.mysql.requests.GetBackupRequest;
import com.oracle.bmc.mysql.requests.ListBackupsRequest;
import com.oracle.bmc.mysql.requests.UpdateBackupRequest;
import com.oracle.bmc.mysql.responses.ChangeBackupCompartmentResponse;
import com.oracle.bmc.mysql.responses.CreateBackupResponse;
import com.oracle.bmc.mysql.responses.DeleteBackupResponse;
import com.oracle.bmc.mysql.responses.GetBackupResponse;
import com.oracle.bmc.mysql.responses.ListBackupsResponse;
import com.oracle.bmc.mysql.responses.UpdateBackupResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbBackupsClient
extends BaseSyncClient
implements DbBackups {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBBACKUPS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbBackupsClient.class);
    private final DbBackupsWaiters waiters;
    private final DbBackupsPaginators paginators;

    DbBackupsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DbBackups-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DbBackupsWaiters(executorService, this);
        this.paginators = new DbBackupsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeBackupCompartmentResponse changeBackupCompartment(ChangeBackupCompartmentRequest request) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBackupCompartmentDetails(), "changeBackupCompartmentDetails is required");
        return (ChangeBackupCompartmentResponse)this.clientCall(request, ChangeBackupCompartmentResponse::builder).logger(LOG, "changeBackupCompartment").serviceDetails("DbBackups", "ChangeBackupCompartment", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/ChangeBackupCompartment").method(Method.POST).requestBuilder(ChangeBackupCompartmentRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeBackupCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeBackupCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest request) {
        Objects.requireNonNull(request.getCreateBackupDetails(), "createBackupDetails is required");
        return (CreateBackupResponse)this.clientCall(request, CreateBackupResponse::builder).logger(LOG, "createBackup").serviceDetails("DbBackups", "CreateBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/CreateBackup").method(Method.POST).requestBuilder(CreateBackupRequest::builder).basePath("/20190415").appendPathParam("backups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Backup.class, CreateBackupResponse.Builder::backup).handleResponseHeaderString("etag", CreateBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateBackupResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateBackupResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest request) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        return (DeleteBackupResponse)this.clientCall(request, DeleteBackupResponse::builder).logger(LOG, "deleteBackup").serviceDetails("DbBackups", "DeleteBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/DeleteBackup").method(Method.DELETE).requestBuilder(DeleteBackupRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteBackupResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteBackupResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetBackupResponse getBackup(GetBackupRequest request) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        return (GetBackupResponse)this.clientCall(request, GetBackupResponse::builder).logger(LOG, "getBackup").serviceDetails("DbBackups", "GetBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/GetBackup").method(Method.GET).requestBuilder(GetBackupRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Backup.class, GetBackupResponse.Builder::backup).handleResponseHeaderString("etag", GetBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBackupResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListBackupsResponse listBackups(ListBackupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListBackupsResponse)this.clientCall(request, ListBackupsResponse::builder).logger(LOG, "listBackups").serviceDetails("DbBackups", "ListBackups", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/BackupSummary/ListBackups").method(Method.GET).requestBuilder(ListBackupsRequest::builder).basePath("/20190415").appendPathParam("backups").appendQueryParam("backupId", (Object)request.getBackupId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("creationType", (BmcEnum)request.getCreationType()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BackupSummary.class, ListBackupsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBackupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBackupsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateBackupResponse updateBackup(UpdateBackupRequest request) {
        Validate.notBlank((String)request.getBackupId(), (String)"backupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBackupDetails(), "updateBackupDetails is required");
        return (UpdateBackupResponse)this.clientCall(request, UpdateBackupResponse::builder).logger(LOG, "updateBackup").serviceDetails("DbBackups", "UpdateBackup", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Backup/UpdateBackup").method(Method.PUT).requestBuilder(UpdateBackupRequest::builder).basePath("/20190415").appendPathParam("backups").appendPathParam(request.getBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Backup.class, UpdateBackupResponse.Builder::backup).handleResponseHeaderString("opc-request-id", UpdateBackupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateBackupResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DbBackupsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DbBackupsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DbBackupsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbBackupsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbBackupsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbBackupsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbBackupsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbBackupsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbBackupsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbBackupsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbBackupsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbBackupsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbBackupsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DbBackupsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbBackupsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

