/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.DbBackups;
import com.oracle.bmc.mysql.model.Backup;
import com.oracle.bmc.mysql.requests.GetBackupRequest;
import com.oracle.bmc.mysql.responses.GetBackupResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DbBackupsWaiters {
    private final ExecutorService executorService;
    private final DbBackups client;

    public DbBackupsWaiters(ExecutorService executorService, DbBackups client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBackupRequest, GetBackupResponse> forBackup(BmcGenericWaiter waiter, GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        final HashSet<Backup.LifecycleState> targetStatesSet = new HashSet<Backup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBackupRequest, GetBackupResponse>(){

            @Override
            public GetBackupResponse apply(GetBackupRequest request) {
                return DbBackupsWaiters.this.client.getBackup(request);
            }
        }, (Predicate)new Predicate<GetBackupResponse>(){

            @Override
            public boolean test(GetBackupResponse response) {
                return targetStatesSet.contains((Object)response.getBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Backup.LifecycleState.Deleted)), (Object)request);
    }
}

