/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.mysql.Mysqlaas;
import com.oracle.bmc.mysql.MysqlaasPaginators;
import com.oracle.bmc.mysql.MysqlaasWaiters;
import com.oracle.bmc.mysql.model.Configuration;
import com.oracle.bmc.mysql.model.ConfigurationSummary;
import com.oracle.bmc.mysql.model.ShapeSummary;
import com.oracle.bmc.mysql.model.VersionSummary;
import com.oracle.bmc.mysql.requests.CreateConfigurationRequest;
import com.oracle.bmc.mysql.requests.DeleteConfigurationRequest;
import com.oracle.bmc.mysql.requests.GetConfigurationRequest;
import com.oracle.bmc.mysql.requests.ListConfigurationsRequest;
import com.oracle.bmc.mysql.requests.ListShapesRequest;
import com.oracle.bmc.mysql.requests.ListVersionsRequest;
import com.oracle.bmc.mysql.requests.UpdateConfigurationRequest;
import com.oracle.bmc.mysql.responses.CreateConfigurationResponse;
import com.oracle.bmc.mysql.responses.DeleteConfigurationResponse;
import com.oracle.bmc.mysql.responses.GetConfigurationResponse;
import com.oracle.bmc.mysql.responses.ListConfigurationsResponse;
import com.oracle.bmc.mysql.responses.ListShapesResponse;
import com.oracle.bmc.mysql.responses.ListVersionsResponse;
import com.oracle.bmc.mysql.responses.UpdateConfigurationResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlaasClient
extends BaseSyncClient
implements Mysqlaas {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MYSQLAAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(MysqlaasClient.class);
    private final MysqlaasWaiters waiters;
    private final MysqlaasPaginators paginators;

    MysqlaasClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Mysqlaas-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new MysqlaasWaiters(executorService, this);
        this.paginators = new MysqlaasPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateConfigurationResponse createConfiguration(CreateConfigurationRequest request) {
        Objects.requireNonNull(request.getCreateConfigurationDetails(), "createConfigurationDetails is required");
        return (CreateConfigurationResponse)this.clientCall(request, CreateConfigurationResponse::builder).logger(LOG, "createConfiguration").serviceDetails("Mysqlaas", "CreateConfiguration", "").method(Method.POST).requestBuilder(CreateConfigurationRequest::builder).basePath("/20190415").appendPathParam("configurations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Configuration.class, CreateConfigurationResponse.Builder::configuration).handleResponseHeaderString("location", CreateConfigurationResponse.Builder::location).handleResponseHeaderString("etag", CreateConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteConfigurationResponse deleteConfiguration(DeleteConfigurationRequest request) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        return (DeleteConfigurationResponse)this.clientCall(request, DeleteConfigurationResponse::builder).logger(LOG, "deleteConfiguration").serviceDetails("Mysqlaas", "DeleteConfiguration", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Configuration/DeleteConfiguration").method(Method.DELETE).requestBuilder(DeleteConfigurationRequest::builder).basePath("/20190415").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetConfigurationResponse getConfiguration(GetConfigurationRequest request) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        return (GetConfigurationResponse)this.clientCall(request, GetConfigurationResponse::builder).logger(LOG, "getConfiguration").serviceDetails("Mysqlaas", "GetConfiguration", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Configuration/GetConfiguration").method(Method.GET).requestBuilder(GetConfigurationRequest::builder).basePath("/20190415").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Configuration.class, GetConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", GetConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListConfigurationsResponse listConfigurations(ListConfigurationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConfigurationsResponse)this.clientCall(request, ListConfigurationsResponse::builder).logger(LOG, "listConfigurations").serviceDetails("Mysqlaas", "ListConfigurations", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/ConfigurationSummary/ListConfigurations").method(Method.GET).requestBuilder(ListConfigurationsRequest::builder).basePath("/20190415").appendPathParam("configurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("shapeName", (Object)request.getShapeName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ConfigurationSummary.class, ListConfigurationsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListConfigurationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConfigurationsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListShapesResponse listShapes(ListShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListShapesResponse)this.clientCall(request, ListShapesResponse::builder).logger(LOG, "listShapes").serviceDetails("Mysqlaas", "ListShapes", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes").method(Method.GET).requestBuilder(ListShapesRequest::builder).basePath("/20190415").appendPathParam("shapes").appendListQueryParam("isSupportedFor", request.getIsSupportedFor(), CollectionFormatType.Multi).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ShapeSummary.class, ListShapesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListShapesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVersionsResponse)this.clientCall(request, ListVersionsResponse::builder).logger(LOG, "listVersions").serviceDetails("Mysqlaas", "ListVersions", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/VersionSummary/ListVersions").method(Method.GET).requestBuilder(ListVersionsRequest::builder).basePath("/20190415").appendPathParam("versions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VersionSummary.class, ListVersionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListVersionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest request) {
        Validate.notBlank((String)request.getConfigurationId(), (String)"configurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConfigurationDetails(), "updateConfigurationDetails is required");
        return (UpdateConfigurationResponse)this.clientCall(request, UpdateConfigurationResponse::builder).logger(LOG, "updateConfiguration").serviceDetails("Mysqlaas", "UpdateConfiguration", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Configuration/UpdateConfiguration").method(Method.PUT).requestBuilder(UpdateConfigurationRequest::builder).basePath("/20190415").appendPathParam("configurations").appendPathParam(request.getConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Configuration.class, UpdateConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", UpdateConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public MysqlaasWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public MysqlaasPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public MysqlaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)MysqlaasClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(MysqlaasClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)MysqlaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)MysqlaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)MysqlaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)MysqlaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MysqlaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public MysqlaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)MysqlaasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MysqlaasClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public MysqlaasClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new MysqlaasClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

