/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.Mysqlaas;
import com.oracle.bmc.mysql.model.ConfigurationSummary;
import com.oracle.bmc.mysql.requests.ListConfigurationsRequest;
import com.oracle.bmc.mysql.responses.ListConfigurationsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class MysqlaasPaginators {
    private final Mysqlaas client;

    public MysqlaasPaginators(Mysqlaas client) {
        this.client = client;
    }

    public Iterable<ListConfigurationsResponse> listConfigurationsResponseIterator(final ListConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConfigurationsRequest.Builder>(){

            @Override
            public ListConfigurationsRequest.Builder get() {
                return ListConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, String>(){

            @Override
            public String apply(ListConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationsRequest.Builder>, ListConfigurationsRequest>(){

            @Override
            public ListConfigurationsRequest apply(RequestBuilderAndToken<ListConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigurationsRequest, ListConfigurationsResponse>(){

            @Override
            public ListConfigurationsResponse apply(ListConfigurationsRequest request) {
                return MysqlaasPaginators.this.client.listConfigurations(request);
            }
        });
    }

    public Iterable<ConfigurationSummary> listConfigurationsRecordIterator(final ListConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConfigurationsRequest.Builder>(){

            @Override
            public ListConfigurationsRequest.Builder get() {
                return ListConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, String>(){

            @Override
            public String apply(ListConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationsRequest.Builder>, ListConfigurationsRequest>(){

            @Override
            public ListConfigurationsRequest apply(RequestBuilderAndToken<ListConfigurationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigurationsRequest, ListConfigurationsResponse>(){

            @Override
            public ListConfigurationsResponse apply(ListConfigurationsRequest request) {
                return MysqlaasPaginators.this.client.listConfigurations(request);
            }
        }, (Function)new Function<ListConfigurationsResponse, List<ConfigurationSummary>>(){

            @Override
            public List<ConfigurationSummary> apply(ListConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }
}

