/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.mysql.DbSystemAsync;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.mysql.model.DbSystemSummary;
import com.oracle.bmc.mysql.model.HeatWaveCluster;
import com.oracle.bmc.mysql.model.HeatWaveClusterMemoryEstimate;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.GenerateHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.RestartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.GenerateHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.RestartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateHeatWaveClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSystemAsyncClient
extends BaseAsyncClient
implements DbSystemAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBSYSTEM").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbSystemAsyncClient.class);

    DbSystemAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddHeatWaveClusterResponse> addHeatWaveCluster(AddHeatWaveClusterRequest request, AsyncHandler<AddHeatWaveClusterRequest, AddHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddHeatWaveClusterDetails(), "addHeatWaveClusterDetails is required");
        return this.clientCall(request, AddHeatWaveClusterResponse::builder).logger(LOG, "addHeatWaveCluster").serviceDetails("DbSystem", "AddHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/AddHeatWaveCluster").method(Method.POST).requestBuilder(AddHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("add").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(HeatWaveCluster.class, AddHeatWaveClusterResponse.Builder::heatWaveCluster).handleResponseHeaderString("etag", AddHeatWaveClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDbSystemResponse> createDbSystem(CreateDbSystemRequest request, AsyncHandler<CreateDbSystemRequest, CreateDbSystemResponse> handler) {
        Objects.requireNonNull(request.getCreateDbSystemDetails(), "createDbSystemDetails is required");
        return this.clientCall(request, CreateDbSystemResponse::builder).logger(LOG, "createDbSystem").serviceDetails("DbSystem", "CreateDbSystem", "").method(Method.POST).requestBuilder(CreateDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DbSystem.class, CreateDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", CreateDbSystemResponse.Builder::etag).handleResponseHeaderString("location", CreateDbSystemResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDbSystemResponse> deleteDbSystem(DeleteDbSystemRequest request, AsyncHandler<DeleteDbSystemRequest, DeleteDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDbSystemResponse::builder).logger(LOG, "deleteDbSystem").serviceDetails("DbSystem", "DeleteDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/DeleteDbSystem").method(Method.DELETE).requestBuilder(DeleteDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteHeatWaveClusterResponse> deleteHeatWaveCluster(DeleteHeatWaveClusterRequest request, AsyncHandler<DeleteHeatWaveClusterRequest, DeleteHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteHeatWaveClusterResponse::builder).logger(LOG, "deleteHeatWaveCluster").serviceDetails("DbSystem", "DeleteHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/DeleteHeatWaveCluster").method(Method.DELETE).requestBuilder(DeleteHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateHeatWaveClusterMemoryEstimateResponse> generateHeatWaveClusterMemoryEstimate(GenerateHeatWaveClusterMemoryEstimateRequest request, AsyncHandler<GenerateHeatWaveClusterMemoryEstimateRequest, GenerateHeatWaveClusterMemoryEstimateResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateHeatWaveClusterMemoryEstimateResponse::builder).logger(LOG, "generateHeatWaveClusterMemoryEstimate").serviceDetails("DbSystem", "GenerateHeatWaveClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveClusterMemoryEstimate/GenerateHeatWaveClusterMemoryEstimate").method(Method.POST).requestBuilder(GenerateHeatWaveClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveClusterMemoryEstimate").appendPathParam("actions").appendPathParam("generate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(HeatWaveClusterMemoryEstimate.class, GenerateHeatWaveClusterMemoryEstimateResponse.Builder::heatWaveClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GenerateHeatWaveClusterMemoryEstimateResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GenerateHeatWaveClusterMemoryEstimateResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request, AsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDbSystemResponse::builder).logger(LOG, "getDbSystem").serviceDetails("DbSystem", "GetDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/GetDbSystem").method(Method.GET).requestBuilder(GetDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(DbSystem.class, GetDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", GetDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHeatWaveClusterResponse> getHeatWaveCluster(GetHeatWaveClusterRequest request, AsyncHandler<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHeatWaveClusterResponse::builder).logger(LOG, "getHeatWaveCluster").serviceDetails("DbSystem", "GetHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/GetHeatWaveCluster").method(Method.GET).requestBuilder(GetHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(HeatWaveCluster.class, GetHeatWaveClusterResponse.Builder::heatWaveCluster).handleResponseHeaderString("etag", GetHeatWaveClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHeatWaveClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHeatWaveClusterMemoryEstimateResponse> getHeatWaveClusterMemoryEstimate(GetHeatWaveClusterMemoryEstimateRequest request, AsyncHandler<GetHeatWaveClusterMemoryEstimateRequest, GetHeatWaveClusterMemoryEstimateResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHeatWaveClusterMemoryEstimateResponse::builder).logger(LOG, "getHeatWaveClusterMemoryEstimate").serviceDetails("DbSystem", "GetHeatWaveClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveClusterMemoryEstimate/GetHeatWaveClusterMemoryEstimate").method(Method.GET).requestBuilder(GetHeatWaveClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveClusterMemoryEstimate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HeatWaveClusterMemoryEstimate.class, GetHeatWaveClusterMemoryEstimateResponse.Builder::heatWaveClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GetHeatWaveClusterMemoryEstimateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request, AsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDbSystemsResponse::builder).logger(LOG, "listDbSystems").serviceDetails("DbSystem", "ListDbSystems", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystemSummary/ListDbSystems").method(Method.GET).requestBuilder(ListDbSystemsRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendQueryParam("isHeatWaveClusterAttached", (Object)request.getIsHeatWaveClusterAttached()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("isUpToDate", (Object)request.getIsUpToDate()).appendListQueryParam("databaseManagement", request.getDatabaseManagement(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DbSystemSummary.class, ListDbSystemsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDbSystemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbSystemsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RestartDbSystemResponse> restartDbSystem(RestartDbSystemRequest request, AsyncHandler<RestartDbSystemRequest, RestartDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestartDbSystemDetails(), "restartDbSystemDetails is required");
        return this.clientCall(request, RestartDbSystemResponse::builder).logger(LOG, "restartDbSystem").serviceDetails("DbSystem", "RestartDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/RestartDbSystem").method(Method.POST).requestBuilder(RestartDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RestartDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RestartHeatWaveClusterResponse> restartHeatWaveCluster(RestartHeatWaveClusterRequest request, AsyncHandler<RestartHeatWaveClusterRequest, RestartHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RestartHeatWaveClusterResponse::builder).logger(LOG, "restartHeatWaveCluster").serviceDetails("DbSystem", "RestartHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/RestartHeatWaveCluster").method(Method.POST).requestBuilder(RestartHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RestartHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartDbSystemResponse> startDbSystem(StartDbSystemRequest request, AsyncHandler<StartDbSystemRequest, StartDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartDbSystemResponse::builder).logger(LOG, "startDbSystem").serviceDetails("DbSystem", "StartDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/StartDbSystem").method(Method.POST).requestBuilder(StartDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartHeatWaveClusterResponse> startHeatWaveCluster(StartHeatWaveClusterRequest request, AsyncHandler<StartHeatWaveClusterRequest, StartHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartHeatWaveClusterResponse::builder).logger(LOG, "startHeatWaveCluster").serviceDetails("DbSystem", "StartHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/StartHeatWaveCluster").method(Method.POST).requestBuilder(StartHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopDbSystemResponse> stopDbSystem(StopDbSystemRequest request, AsyncHandler<StopDbSystemRequest, StopDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStopDbSystemDetails(), "stopDbSystemDetails is required");
        return this.clientCall(request, StopDbSystemResponse::builder).logger(LOG, "stopDbSystem").serviceDetails("DbSystem", "StopDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/StopDbSystem").method(Method.POST).requestBuilder(StopDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", StopDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopHeatWaveClusterResponse> stopHeatWaveCluster(StopHeatWaveClusterRequest request, AsyncHandler<StopHeatWaveClusterRequest, StopHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopHeatWaveClusterResponse::builder).logger(LOG, "stopHeatWaveCluster").serviceDetails("DbSystem", "StopHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/StopHeatWaveCluster").method(Method.POST).requestBuilder(StopHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request, AsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbSystemDetails(), "updateDbSystemDetails is required");
        return this.clientCall(request, UpdateDbSystemResponse::builder).logger(LOG, "updateDbSystem").serviceDetails("DbSystem", "UpdateDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/UpdateDbSystem").method(Method.PUT).requestBuilder(UpdateDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateHeatWaveClusterResponse> updateHeatWaveCluster(UpdateHeatWaveClusterRequest request, AsyncHandler<UpdateHeatWaveClusterRequest, UpdateHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHeatWaveClusterDetails(), "updateHeatWaveClusterDetails is required");
        return this.clientCall(request, UpdateHeatWaveClusterResponse::builder).logger(LOG, "updateHeatWaveCluster").serviceDetails("DbSystem", "UpdateHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/UpdateHeatWaveCluster").method(Method.PUT).requestBuilder(UpdateHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbSystemAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbSystemAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbSystemAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "mysql";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"mysql");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DbSystemAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbSystemAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

