/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeletionPolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="automaticBackupRetention")
    private final AutomaticBackupRetention automaticBackupRetention;
    @JsonProperty(value="finalBackup")
    private final FinalBackup finalBackup;
    @JsonProperty(value="isDeleteProtected")
    private final Boolean isDeleteProtected;

    @Deprecated
    @ConstructorProperties(value={"automaticBackupRetention", "finalBackup", "isDeleteProtected"})
    public DeletionPolicyDetails(AutomaticBackupRetention automaticBackupRetention, FinalBackup finalBackup, Boolean isDeleteProtected) {
        this.automaticBackupRetention = automaticBackupRetention;
        this.finalBackup = finalBackup;
        this.isDeleteProtected = isDeleteProtected;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AutomaticBackupRetention getAutomaticBackupRetention() {
        return this.automaticBackupRetention;
    }

    public FinalBackup getFinalBackup() {
        return this.finalBackup;
    }

    public Boolean getIsDeleteProtected() {
        return this.isDeleteProtected;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeletionPolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("automaticBackupRetention=").append(String.valueOf((Object)this.automaticBackupRetention));
        sb.append(", finalBackup=").append(String.valueOf((Object)this.finalBackup));
        sb.append(", isDeleteProtected=").append(String.valueOf(this.isDeleteProtected));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeletionPolicyDetails)) {
            return false;
        }
        DeletionPolicyDetails other = (DeletionPolicyDetails)((Object)o);
        return Objects.equals((Object)this.automaticBackupRetention, (Object)other.automaticBackupRetention) && Objects.equals((Object)this.finalBackup, (Object)other.finalBackup) && Objects.equals(this.isDeleteProtected, other.isDeleteProtected) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.automaticBackupRetention == null ? 43 : this.automaticBackupRetention.hashCode());
        result = result * 59 + (this.finalBackup == null ? 43 : this.finalBackup.hashCode());
        result = result * 59 + (this.isDeleteProtected == null ? 43 : this.isDeleteProtected.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FinalBackup implements BmcEnum
    {
        SkipFinalBackup("SKIP_FINAL_BACKUP"),
        RequireFinalBackup("REQUIRE_FINAL_BACKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FinalBackup> map;

        private FinalBackup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FinalBackup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FinalBackup', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FinalBackup.class);
            map = new HashMap<String, FinalBackup>();
            for (FinalBackup v : FinalBackup.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AutomaticBackupRetention implements BmcEnum
    {
        Delete("DELETE"),
        Retain("RETAIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AutomaticBackupRetention> map;

        private AutomaticBackupRetention(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AutomaticBackupRetention create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AutomaticBackupRetention', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AutomaticBackupRetention.class);
            map = new HashMap<String, AutomaticBackupRetention>();
            for (AutomaticBackupRetention v : AutomaticBackupRetention.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="automaticBackupRetention")
        private AutomaticBackupRetention automaticBackupRetention;
        @JsonProperty(value="finalBackup")
        private FinalBackup finalBackup;
        @JsonProperty(value="isDeleteProtected")
        private Boolean isDeleteProtected;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder automaticBackupRetention(AutomaticBackupRetention automaticBackupRetention) {
            this.automaticBackupRetention = automaticBackupRetention;
            this.__explicitlySet__.add("automaticBackupRetention");
            return this;
        }

        public Builder finalBackup(FinalBackup finalBackup) {
            this.finalBackup = finalBackup;
            this.__explicitlySet__.add("finalBackup");
            return this;
        }

        public Builder isDeleteProtected(Boolean isDeleteProtected) {
            this.isDeleteProtected = isDeleteProtected;
            this.__explicitlySet__.add("isDeleteProtected");
            return this;
        }

        public DeletionPolicyDetails build() {
            DeletionPolicyDetails model = new DeletionPolicyDetails(this.automaticBackupRetention, this.finalBackup, this.isDeleteProtected);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeletionPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("automaticBackupRetention")) {
                this.automaticBackupRetention(model.getAutomaticBackupRetention());
            }
            if (model.wasPropertyExplicitlySet("finalBackup")) {
                this.finalBackup(model.getFinalBackup());
            }
            if (model.wasPropertyExplicitlySet("isDeleteProtected")) {
                this.isDeleteProtected(model.getIsDeleteProtected());
            }
            return this;
        }
    }
}

