/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataStorage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="allocatedStorageSizeInGBs")
    private final Integer allocatedStorageSizeInGBs;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Integer dataStorageSizeInGBs;
    @JsonProperty(value="dataStorageSizeLimitInGBs")
    private final Integer dataStorageSizeLimitInGBs;
    @JsonProperty(value="isAutoExpandStorageEnabled")
    private final Boolean isAutoExpandStorageEnabled;
    @JsonProperty(value="maxStorageSizeInGBs")
    private final Integer maxStorageSizeInGBs;

    @Deprecated
    @ConstructorProperties(value={"allocatedStorageSizeInGBs", "dataStorageSizeInGBs", "dataStorageSizeLimitInGBs", "isAutoExpandStorageEnabled", "maxStorageSizeInGBs"})
    public DataStorage(Integer allocatedStorageSizeInGBs, Integer dataStorageSizeInGBs, Integer dataStorageSizeLimitInGBs, Boolean isAutoExpandStorageEnabled, Integer maxStorageSizeInGBs) {
        this.allocatedStorageSizeInGBs = allocatedStorageSizeInGBs;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.dataStorageSizeLimitInGBs = dataStorageSizeLimitInGBs;
        this.isAutoExpandStorageEnabled = isAutoExpandStorageEnabled;
        this.maxStorageSizeInGBs = maxStorageSizeInGBs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getAllocatedStorageSizeInGBs() {
        return this.allocatedStorageSizeInGBs;
    }

    public Integer getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public Integer getDataStorageSizeLimitInGBs() {
        return this.dataStorageSizeLimitInGBs;
    }

    public Boolean getIsAutoExpandStorageEnabled() {
        return this.isAutoExpandStorageEnabled;
    }

    public Integer getMaxStorageSizeInGBs() {
        return this.maxStorageSizeInGBs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataStorage(");
        sb.append("super=").append(super.toString());
        sb.append("allocatedStorageSizeInGBs=").append(String.valueOf(this.allocatedStorageSizeInGBs));
        sb.append(", dataStorageSizeInGBs=").append(String.valueOf(this.dataStorageSizeInGBs));
        sb.append(", dataStorageSizeLimitInGBs=").append(String.valueOf(this.dataStorageSizeLimitInGBs));
        sb.append(", isAutoExpandStorageEnabled=").append(String.valueOf(this.isAutoExpandStorageEnabled));
        sb.append(", maxStorageSizeInGBs=").append(String.valueOf(this.maxStorageSizeInGBs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataStorage)) {
            return false;
        }
        DataStorage other = (DataStorage)((Object)o);
        return Objects.equals(this.allocatedStorageSizeInGBs, other.allocatedStorageSizeInGBs) && Objects.equals(this.dataStorageSizeInGBs, other.dataStorageSizeInGBs) && Objects.equals(this.dataStorageSizeLimitInGBs, other.dataStorageSizeLimitInGBs) && Objects.equals(this.isAutoExpandStorageEnabled, other.isAutoExpandStorageEnabled) && Objects.equals(this.maxStorageSizeInGBs, other.maxStorageSizeInGBs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allocatedStorageSizeInGBs == null ? 43 : this.allocatedStorageSizeInGBs.hashCode());
        result = result * 59 + (this.dataStorageSizeInGBs == null ? 43 : this.dataStorageSizeInGBs.hashCode());
        result = result * 59 + (this.dataStorageSizeLimitInGBs == null ? 43 : this.dataStorageSizeLimitInGBs.hashCode());
        result = result * 59 + (this.isAutoExpandStorageEnabled == null ? 43 : this.isAutoExpandStorageEnabled.hashCode());
        result = result * 59 + (this.maxStorageSizeInGBs == null ? 43 : this.maxStorageSizeInGBs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="allocatedStorageSizeInGBs")
        private Integer allocatedStorageSizeInGBs;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Integer dataStorageSizeInGBs;
        @JsonProperty(value="dataStorageSizeLimitInGBs")
        private Integer dataStorageSizeLimitInGBs;
        @JsonProperty(value="isAutoExpandStorageEnabled")
        private Boolean isAutoExpandStorageEnabled;
        @JsonProperty(value="maxStorageSizeInGBs")
        private Integer maxStorageSizeInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder allocatedStorageSizeInGBs(Integer allocatedStorageSizeInGBs) {
            this.allocatedStorageSizeInGBs = allocatedStorageSizeInGBs;
            this.__explicitlySet__.add("allocatedStorageSizeInGBs");
            return this;
        }

        public Builder dataStorageSizeInGBs(Integer dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder dataStorageSizeLimitInGBs(Integer dataStorageSizeLimitInGBs) {
            this.dataStorageSizeLimitInGBs = dataStorageSizeLimitInGBs;
            this.__explicitlySet__.add("dataStorageSizeLimitInGBs");
            return this;
        }

        public Builder isAutoExpandStorageEnabled(Boolean isAutoExpandStorageEnabled) {
            this.isAutoExpandStorageEnabled = isAutoExpandStorageEnabled;
            this.__explicitlySet__.add("isAutoExpandStorageEnabled");
            return this;
        }

        public Builder maxStorageSizeInGBs(Integer maxStorageSizeInGBs) {
            this.maxStorageSizeInGBs = maxStorageSizeInGBs;
            this.__explicitlySet__.add("maxStorageSizeInGBs");
            return this;
        }

        public DataStorage build() {
            DataStorage model = new DataStorage(this.allocatedStorageSizeInGBs, this.dataStorageSizeInGBs, this.dataStorageSizeLimitInGBs, this.isAutoExpandStorageEnabled, this.maxStorageSizeInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataStorage model) {
            if (model.wasPropertyExplicitlySet("allocatedStorageSizeInGBs")) {
                this.allocatedStorageSizeInGBs(model.getAllocatedStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInGBs")) {
                this.dataStorageSizeInGBs(model.getDataStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeLimitInGBs")) {
                this.dataStorageSizeLimitInGBs(model.getDataStorageSizeLimitInGBs());
            }
            if (model.wasPropertyExplicitlySet("isAutoExpandStorageEnabled")) {
                this.isAutoExpandStorageEnabled(model.getIsAutoExpandStorageEnabled());
            }
            if (model.wasPropertyExplicitlySet("maxStorageSizeInGBs")) {
                this.maxStorageSizeInGBs(model.getMaxStorageSizeInGBs());
            }
            return this;
        }
    }
}

