/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.mysql.model.BackupPolicy;
import com.oracle.bmc.mysql.model.ChannelSummary;
import com.oracle.bmc.mysql.model.CrashRecoveryStatus;
import com.oracle.bmc.mysql.model.CustomerContact;
import com.oracle.bmc.mysql.model.DataStorage;
import com.oracle.bmc.mysql.model.DatabaseManagementStatus;
import com.oracle.bmc.mysql.model.DbSystemEndpoint;
import com.oracle.bmc.mysql.model.DbSystemPlacement;
import com.oracle.bmc.mysql.model.DbSystemSource;
import com.oracle.bmc.mysql.model.DeletionPolicyDetails;
import com.oracle.bmc.mysql.model.HeatWaveClusterSummary;
import com.oracle.bmc.mysql.model.MaintenanceDetails;
import com.oracle.bmc.mysql.model.PointInTimeRecoveryDetails;
import com.oracle.bmc.mysql.model.SecureConnectionDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="isHighlyAvailable")
    private final Boolean isHighlyAvailable;
    @JsonProperty(value="currentPlacement")
    private final DbSystemPlacement currentPlacement;
    @JsonProperty(value="isHeatWaveClusterAttached")
    private final Boolean isHeatWaveClusterAttached;
    @JsonProperty(value="heatWaveCluster")
    private final HeatWaveClusterSummary heatWaveCluster;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="mysqlVersion")
    private final String mysqlVersion;
    @JsonProperty(value="backupPolicy")
    private final BackupPolicy backupPolicy;
    @JsonProperty(value="source")
    private final DbSystemSource source;
    @JsonProperty(value="configurationId")
    private final String configurationId;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Integer dataStorageSizeInGBs;
    @JsonProperty(value="dataStorage")
    private final DataStorage dataStorage;
    @JsonProperty(value="hostnameLabel")
    private final String hostnameLabel;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="portX")
    private final Integer portX;
    @JsonProperty(value="endpoints")
    private final List<DbSystemEndpoint> endpoints;
    @JsonProperty(value="channels")
    private final List<ChannelSummary> channels;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="maintenance")
    private final MaintenanceDetails maintenance;
    @JsonProperty(value="deletionPolicy")
    private final DeletionPolicyDetails deletionPolicy;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="crashRecovery")
    private final CrashRecoveryStatus crashRecovery;
    @JsonProperty(value="pointInTimeRecoveryDetails")
    private final PointInTimeRecoveryDetails pointInTimeRecoveryDetails;
    @JsonProperty(value="databaseManagement")
    private final DatabaseManagementStatus databaseManagement;
    @JsonProperty(value="secureConnections")
    private final SecureConnectionDetails secureConnections;
    @JsonProperty(value="customerContacts")
    private final List<CustomerContact> customerContacts;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "subnetId", "isHighlyAvailable", "currentPlacement", "isHeatWaveClusterAttached", "heatWaveCluster", "availabilityDomain", "faultDomain", "shapeName", "mysqlVersion", "backupPolicy", "source", "configurationId", "dataStorageSizeInGBs", "dataStorage", "hostnameLabel", "ipAddress", "port", "portX", "endpoints", "channels", "lifecycleState", "lifecycleDetails", "maintenance", "deletionPolicy", "timeCreated", "timeUpdated", "freeformTags", "definedTags", "crashRecovery", "pointInTimeRecoveryDetails", "databaseManagement", "secureConnections", "customerContacts"})
    public DbSystem(String id, String displayName, String description, String compartmentId, String subnetId, Boolean isHighlyAvailable, DbSystemPlacement currentPlacement, Boolean isHeatWaveClusterAttached, HeatWaveClusterSummary heatWaveCluster, String availabilityDomain, String faultDomain, String shapeName, String mysqlVersion, BackupPolicy backupPolicy, DbSystemSource source, String configurationId, Integer dataStorageSizeInGBs, DataStorage dataStorage, String hostnameLabel, String ipAddress, Integer port, Integer portX, List<DbSystemEndpoint> endpoints, List<ChannelSummary> channels, LifecycleState lifecycleState, String lifecycleDetails, MaintenanceDetails maintenance, DeletionPolicyDetails deletionPolicy, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, CrashRecoveryStatus crashRecovery, PointInTimeRecoveryDetails pointInTimeRecoveryDetails, DatabaseManagementStatus databaseManagement, SecureConnectionDetails secureConnections, List<CustomerContact> customerContacts) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.subnetId = subnetId;
        this.isHighlyAvailable = isHighlyAvailable;
        this.currentPlacement = currentPlacement;
        this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
        this.heatWaveCluster = heatWaveCluster;
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.shapeName = shapeName;
        this.mysqlVersion = mysqlVersion;
        this.backupPolicy = backupPolicy;
        this.source = source;
        this.configurationId = configurationId;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.dataStorage = dataStorage;
        this.hostnameLabel = hostnameLabel;
        this.ipAddress = ipAddress;
        this.port = port;
        this.portX = portX;
        this.endpoints = endpoints;
        this.channels = channels;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.maintenance = maintenance;
        this.deletionPolicy = deletionPolicy;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.crashRecovery = crashRecovery;
        this.pointInTimeRecoveryDetails = pointInTimeRecoveryDetails;
        this.databaseManagement = databaseManagement;
        this.secureConnections = secureConnections;
        this.customerContacts = customerContacts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Boolean getIsHighlyAvailable() {
        return this.isHighlyAvailable;
    }

    public DbSystemPlacement getCurrentPlacement() {
        return this.currentPlacement;
    }

    public Boolean getIsHeatWaveClusterAttached() {
        return this.isHeatWaveClusterAttached;
    }

    public HeatWaveClusterSummary getHeatWaveCluster() {
        return this.heatWaveCluster;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public String getMysqlVersion() {
        return this.mysqlVersion;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public DbSystemSource getSource() {
        return this.source;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public Integer getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public DataStorage getDataStorage() {
        return this.dataStorage;
    }

    public String getHostnameLabel() {
        return this.hostnameLabel;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getPortX() {
        return this.portX;
    }

    public List<DbSystemEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public List<ChannelSummary> getChannels() {
        return this.channels;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public MaintenanceDetails getMaintenance() {
        return this.maintenance;
    }

    public DeletionPolicyDetails getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public CrashRecoveryStatus getCrashRecovery() {
        return this.crashRecovery;
    }

    public PointInTimeRecoveryDetails getPointInTimeRecoveryDetails() {
        return this.pointInTimeRecoveryDetails;
    }

    public DatabaseManagementStatus getDatabaseManagement() {
        return this.databaseManagement;
    }

    public SecureConnectionDetails getSecureConnections() {
        return this.secureConnections;
    }

    public List<CustomerContact> getCustomerContacts() {
        return this.customerContacts;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystem(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", isHighlyAvailable=").append(String.valueOf(this.isHighlyAvailable));
        sb.append(", currentPlacement=").append(String.valueOf((Object)this.currentPlacement));
        sb.append(", isHeatWaveClusterAttached=").append(String.valueOf(this.isHeatWaveClusterAttached));
        sb.append(", heatWaveCluster=").append(String.valueOf((Object)this.heatWaveCluster));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", mysqlVersion=").append(String.valueOf(this.mysqlVersion));
        sb.append(", backupPolicy=").append(String.valueOf((Object)this.backupPolicy));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", configurationId=").append(String.valueOf(this.configurationId));
        sb.append(", dataStorageSizeInGBs=").append(String.valueOf(this.dataStorageSizeInGBs));
        sb.append(", dataStorage=").append(String.valueOf((Object)this.dataStorage));
        sb.append(", hostnameLabel=").append(String.valueOf(this.hostnameLabel));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", portX=").append(String.valueOf(this.portX));
        sb.append(", endpoints=").append(String.valueOf(this.endpoints));
        sb.append(", channels=").append(String.valueOf(this.channels));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", maintenance=").append(String.valueOf((Object)this.maintenance));
        sb.append(", deletionPolicy=").append(String.valueOf((Object)this.deletionPolicy));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", crashRecovery=").append(String.valueOf((Object)this.crashRecovery));
        sb.append(", pointInTimeRecoveryDetails=").append(String.valueOf((Object)this.pointInTimeRecoveryDetails));
        sb.append(", databaseManagement=").append(String.valueOf((Object)this.databaseManagement));
        sb.append(", secureConnections=").append(String.valueOf((Object)this.secureConnections));
        sb.append(", customerContacts=").append(String.valueOf(this.customerContacts));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystem)) {
            return false;
        }
        DbSystem other = (DbSystem)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.isHighlyAvailable, other.isHighlyAvailable) && Objects.equals((Object)this.currentPlacement, (Object)other.currentPlacement) && Objects.equals(this.isHeatWaveClusterAttached, other.isHeatWaveClusterAttached) && Objects.equals((Object)this.heatWaveCluster, (Object)other.heatWaveCluster) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals(this.mysqlVersion, other.mysqlVersion) && Objects.equals((Object)this.backupPolicy, (Object)other.backupPolicy) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.configurationId, other.configurationId) && Objects.equals(this.dataStorageSizeInGBs, other.dataStorageSizeInGBs) && Objects.equals((Object)this.dataStorage, (Object)other.dataStorage) && Objects.equals(this.hostnameLabel, other.hostnameLabel) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.port, other.port) && Objects.equals(this.portX, other.portX) && Objects.equals(this.endpoints, other.endpoints) && Objects.equals(this.channels, other.channels) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.maintenance, (Object)other.maintenance) && Objects.equals((Object)this.deletionPolicy, (Object)other.deletionPolicy) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.crashRecovery, (Object)other.crashRecovery) && Objects.equals((Object)this.pointInTimeRecoveryDetails, (Object)other.pointInTimeRecoveryDetails) && Objects.equals((Object)this.databaseManagement, (Object)other.databaseManagement) && Objects.equals((Object)this.secureConnections, (Object)other.secureConnections) && Objects.equals(this.customerContacts, other.customerContacts) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.isHighlyAvailable == null ? 43 : this.isHighlyAvailable.hashCode());
        result = result * 59 + (this.currentPlacement == null ? 43 : this.currentPlacement.hashCode());
        result = result * 59 + (this.isHeatWaveClusterAttached == null ? 43 : this.isHeatWaveClusterAttached.hashCode());
        result = result * 59 + (this.heatWaveCluster == null ? 43 : this.heatWaveCluster.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.mysqlVersion == null ? 43 : this.mysqlVersion.hashCode());
        result = result * 59 + (this.backupPolicy == null ? 43 : this.backupPolicy.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.configurationId == null ? 43 : this.configurationId.hashCode());
        result = result * 59 + (this.dataStorageSizeInGBs == null ? 43 : this.dataStorageSizeInGBs.hashCode());
        result = result * 59 + (this.dataStorage == null ? 43 : this.dataStorage.hashCode());
        result = result * 59 + (this.hostnameLabel == null ? 43 : this.hostnameLabel.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.portX == null ? 43 : this.portX.hashCode());
        result = result * 59 + (this.endpoints == null ? 43 : this.endpoints.hashCode());
        result = result * 59 + (this.channels == null ? 43 : this.channels.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.maintenance == null ? 43 : this.maintenance.hashCode());
        result = result * 59 + (this.deletionPolicy == null ? 43 : this.deletionPolicy.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.crashRecovery == null ? 43 : this.crashRecovery.hashCode());
        result = result * 59 + (this.pointInTimeRecoveryDetails == null ? 43 : this.pointInTimeRecoveryDetails.hashCode());
        result = result * 59 + (this.databaseManagement == null ? 43 : this.databaseManagement.hashCode());
        result = result * 59 + (this.secureConnections == null ? 43 : this.secureConnections.hashCode());
        result = result * 59 + (this.customerContacts == null ? 43 : this.customerContacts.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="isHighlyAvailable")
        private Boolean isHighlyAvailable;
        @JsonProperty(value="currentPlacement")
        private DbSystemPlacement currentPlacement;
        @JsonProperty(value="isHeatWaveClusterAttached")
        private Boolean isHeatWaveClusterAttached;
        @JsonProperty(value="heatWaveCluster")
        private HeatWaveClusterSummary heatWaveCluster;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="mysqlVersion")
        private String mysqlVersion;
        @JsonProperty(value="backupPolicy")
        private BackupPolicy backupPolicy;
        @JsonProperty(value="source")
        private DbSystemSource source;
        @JsonProperty(value="configurationId")
        private String configurationId;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Integer dataStorageSizeInGBs;
        @JsonProperty(value="dataStorage")
        private DataStorage dataStorage;
        @JsonProperty(value="hostnameLabel")
        private String hostnameLabel;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="portX")
        private Integer portX;
        @JsonProperty(value="endpoints")
        private List<DbSystemEndpoint> endpoints;
        @JsonProperty(value="channels")
        private List<ChannelSummary> channels;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="maintenance")
        private MaintenanceDetails maintenance;
        @JsonProperty(value="deletionPolicy")
        private DeletionPolicyDetails deletionPolicy;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="crashRecovery")
        private CrashRecoveryStatus crashRecovery;
        @JsonProperty(value="pointInTimeRecoveryDetails")
        private PointInTimeRecoveryDetails pointInTimeRecoveryDetails;
        @JsonProperty(value="databaseManagement")
        private DatabaseManagementStatus databaseManagement;
        @JsonProperty(value="secureConnections")
        private SecureConnectionDetails secureConnections;
        @JsonProperty(value="customerContacts")
        private List<CustomerContact> customerContacts;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder isHighlyAvailable(Boolean isHighlyAvailable) {
            this.isHighlyAvailable = isHighlyAvailable;
            this.__explicitlySet__.add("isHighlyAvailable");
            return this;
        }

        public Builder currentPlacement(DbSystemPlacement currentPlacement) {
            this.currentPlacement = currentPlacement;
            this.__explicitlySet__.add("currentPlacement");
            return this;
        }

        public Builder isHeatWaveClusterAttached(Boolean isHeatWaveClusterAttached) {
            this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
            this.__explicitlySet__.add("isHeatWaveClusterAttached");
            return this;
        }

        public Builder heatWaveCluster(HeatWaveClusterSummary heatWaveCluster) {
            this.heatWaveCluster = heatWaveCluster;
            this.__explicitlySet__.add("heatWaveCluster");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder mysqlVersion(String mysqlVersion) {
            this.mysqlVersion = mysqlVersion;
            this.__explicitlySet__.add("mysqlVersion");
            return this;
        }

        public Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy = backupPolicy;
            this.__explicitlySet__.add("backupPolicy");
            return this;
        }

        public Builder source(DbSystemSource source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            this.__explicitlySet__.add("configurationId");
            return this;
        }

        public Builder dataStorageSizeInGBs(Integer dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder dataStorage(DataStorage dataStorage) {
            this.dataStorage = dataStorage;
            this.__explicitlySet__.add("dataStorage");
            return this;
        }

        public Builder hostnameLabel(String hostnameLabel) {
            this.hostnameLabel = hostnameLabel;
            this.__explicitlySet__.add("hostnameLabel");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder portX(Integer portX) {
            this.portX = portX;
            this.__explicitlySet__.add("portX");
            return this;
        }

        public Builder endpoints(List<DbSystemEndpoint> endpoints) {
            this.endpoints = endpoints;
            this.__explicitlySet__.add("endpoints");
            return this;
        }

        public Builder channels(List<ChannelSummary> channels) {
            this.channels = channels;
            this.__explicitlySet__.add("channels");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder maintenance(MaintenanceDetails maintenance) {
            this.maintenance = maintenance;
            this.__explicitlySet__.add("maintenance");
            return this;
        }

        public Builder deletionPolicy(DeletionPolicyDetails deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
            this.__explicitlySet__.add("deletionPolicy");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder crashRecovery(CrashRecoveryStatus crashRecovery) {
            this.crashRecovery = crashRecovery;
            this.__explicitlySet__.add("crashRecovery");
            return this;
        }

        public Builder pointInTimeRecoveryDetails(PointInTimeRecoveryDetails pointInTimeRecoveryDetails) {
            this.pointInTimeRecoveryDetails = pointInTimeRecoveryDetails;
            this.__explicitlySet__.add("pointInTimeRecoveryDetails");
            return this;
        }

        public Builder databaseManagement(DatabaseManagementStatus databaseManagement) {
            this.databaseManagement = databaseManagement;
            this.__explicitlySet__.add("databaseManagement");
            return this;
        }

        public Builder secureConnections(SecureConnectionDetails secureConnections) {
            this.secureConnections = secureConnections;
            this.__explicitlySet__.add("secureConnections");
            return this;
        }

        public Builder customerContacts(List<CustomerContact> customerContacts) {
            this.customerContacts = customerContacts;
            this.__explicitlySet__.add("customerContacts");
            return this;
        }

        public DbSystem build() {
            DbSystem model = new DbSystem(this.id, this.displayName, this.description, this.compartmentId, this.subnetId, this.isHighlyAvailable, this.currentPlacement, this.isHeatWaveClusterAttached, this.heatWaveCluster, this.availabilityDomain, this.faultDomain, this.shapeName, this.mysqlVersion, this.backupPolicy, this.source, this.configurationId, this.dataStorageSizeInGBs, this.dataStorage, this.hostnameLabel, this.ipAddress, this.port, this.portX, this.endpoints, this.channels, this.lifecycleState, this.lifecycleDetails, this.maintenance, this.deletionPolicy, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.crashRecovery, this.pointInTimeRecoveryDetails, this.databaseManagement, this.secureConnections, this.customerContacts);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystem model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("isHighlyAvailable")) {
                this.isHighlyAvailable(model.getIsHighlyAvailable());
            }
            if (model.wasPropertyExplicitlySet("currentPlacement")) {
                this.currentPlacement(model.getCurrentPlacement());
            }
            if (model.wasPropertyExplicitlySet("isHeatWaveClusterAttached")) {
                this.isHeatWaveClusterAttached(model.getIsHeatWaveClusterAttached());
            }
            if (model.wasPropertyExplicitlySet("heatWaveCluster")) {
                this.heatWaveCluster(model.getHeatWaveCluster());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("mysqlVersion")) {
                this.mysqlVersion(model.getMysqlVersion());
            }
            if (model.wasPropertyExplicitlySet("backupPolicy")) {
                this.backupPolicy(model.getBackupPolicy());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("configurationId")) {
                this.configurationId(model.getConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInGBs")) {
                this.dataStorageSizeInGBs(model.getDataStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorage")) {
                this.dataStorage(model.getDataStorage());
            }
            if (model.wasPropertyExplicitlySet("hostnameLabel")) {
                this.hostnameLabel(model.getHostnameLabel());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("portX")) {
                this.portX(model.getPortX());
            }
            if (model.wasPropertyExplicitlySet("endpoints")) {
                this.endpoints(model.getEndpoints());
            }
            if (model.wasPropertyExplicitlySet("channels")) {
                this.channels(model.getChannels());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("maintenance")) {
                this.maintenance(model.getMaintenance());
            }
            if (model.wasPropertyExplicitlySet("deletionPolicy")) {
                this.deletionPolicy(model.getDeletionPolicy());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("crashRecovery")) {
                this.crashRecovery(model.getCrashRecovery());
            }
            if (model.wasPropertyExplicitlySet("pointInTimeRecoveryDetails")) {
                this.pointInTimeRecoveryDetails(model.getPointInTimeRecoveryDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseManagement")) {
                this.databaseManagement(model.getDatabaseManagement());
            }
            if (model.wasPropertyExplicitlySet("secureConnections")) {
                this.secureConnections(model.getSecureConnections());
            }
            if (model.wasPropertyExplicitlySet("customerContacts")) {
                this.customerContacts(model.getCustomerContacts());
            }
            return this;
        }
    }
}

