/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.mysql.DbSystemPaginators;
import com.oracle.bmc.mysql.DbSystemWaiters;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.mysql.model.DbSystemSummary;
import com.oracle.bmc.mysql.model.HeatWaveCluster;
import com.oracle.bmc.mysql.model.HeatWaveClusterMemoryEstimate;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.GenerateHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.RestartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.GenerateHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.RestartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateHeatWaveClusterResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSystemClient
extends BaseSyncClient
implements com.oracle.bmc.mysql.DbSystem {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBSYSTEM").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbSystemClient.class);
    private final DbSystemWaiters waiters;
    private final DbSystemPaginators paginators;

    DbSystemClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DbSystem-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DbSystemWaiters(executorService, this);
        this.paginators = new DbSystemPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddHeatWaveClusterResponse addHeatWaveCluster(AddHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddHeatWaveClusterDetails(), "addHeatWaveClusterDetails is required");
        return (AddHeatWaveClusterResponse)this.clientCall(request, AddHeatWaveClusterResponse::builder).logger(LOG, "addHeatWaveCluster").serviceDetails("DbSystem", "AddHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/AddHeatWaveCluster").method(Method.POST).requestBuilder(AddHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("add").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(HeatWaveCluster.class, AddHeatWaveClusterResponse.Builder::heatWaveCluster).handleResponseHeaderString("etag", AddHeatWaveClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddHeatWaveClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateDbSystemResponse createDbSystem(CreateDbSystemRequest request) {
        Objects.requireNonNull(request.getCreateDbSystemDetails(), "createDbSystemDetails is required");
        return (CreateDbSystemResponse)this.clientCall(request, CreateDbSystemResponse::builder).logger(LOG, "createDbSystem").serviceDetails("DbSystem", "CreateDbSystem", "").method(Method.POST).requestBuilder(CreateDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(DbSystem.class, CreateDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", CreateDbSystemResponse.Builder::etag).handleResponseHeaderString("location", CreateDbSystemResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDbSystemResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteDbSystemResponse deleteDbSystem(DeleteDbSystemRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (DeleteDbSystemResponse)this.clientCall(request, DeleteDbSystemResponse::builder).logger(LOG, "deleteDbSystem").serviceDetails("DbSystem", "DeleteDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/DeleteDbSystem").method(Method.DELETE).requestBuilder(DeleteDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDbSystemResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteHeatWaveClusterResponse deleteHeatWaveCluster(DeleteHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (DeleteHeatWaveClusterResponse)this.clientCall(request, DeleteHeatWaveClusterResponse::builder).logger(LOG, "deleteHeatWaveCluster").serviceDetails("DbSystem", "DeleteHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/DeleteHeatWaveCluster").method(Method.DELETE).requestBuilder(DeleteHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteHeatWaveClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GenerateHeatWaveClusterMemoryEstimateResponse generateHeatWaveClusterMemoryEstimate(GenerateHeatWaveClusterMemoryEstimateRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (GenerateHeatWaveClusterMemoryEstimateResponse)this.clientCall(request, GenerateHeatWaveClusterMemoryEstimateResponse::builder).logger(LOG, "generateHeatWaveClusterMemoryEstimate").serviceDetails("DbSystem", "GenerateHeatWaveClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveClusterMemoryEstimate/GenerateHeatWaveClusterMemoryEstimate").method(Method.POST).requestBuilder(GenerateHeatWaveClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveClusterMemoryEstimate").appendPathParam("actions").appendPathParam("generate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleBody(HeatWaveClusterMemoryEstimate.class, GenerateHeatWaveClusterMemoryEstimateResponse.Builder::heatWaveClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GenerateHeatWaveClusterMemoryEstimateResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GenerateHeatWaveClusterMemoryEstimateResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetDbSystemResponse getDbSystem(GetDbSystemRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (GetDbSystemResponse)this.clientCall(request, GetDbSystemResponse::builder).logger(LOG, "getDbSystem").serviceDetails("DbSystem", "GetDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/GetDbSystem").method(Method.GET).requestBuilder(GetDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).operationUsesDefaultRetries().handleBody(DbSystem.class, GetDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", GetDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDbSystemResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHeatWaveClusterResponse getHeatWaveCluster(GetHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (GetHeatWaveClusterResponse)this.clientCall(request, GetHeatWaveClusterResponse::builder).logger(LOG, "getHeatWaveCluster").serviceDetails("DbSystem", "GetHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/GetHeatWaveCluster").method(Method.GET).requestBuilder(GetHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).operationUsesDefaultRetries().handleBody(HeatWaveCluster.class, GetHeatWaveClusterResponse.Builder::heatWaveCluster).handleResponseHeaderString("etag", GetHeatWaveClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHeatWaveClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetHeatWaveClusterMemoryEstimateResponse getHeatWaveClusterMemoryEstimate(GetHeatWaveClusterMemoryEstimateRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (GetHeatWaveClusterMemoryEstimateResponse)this.clientCall(request, GetHeatWaveClusterMemoryEstimateResponse::builder).logger(LOG, "getHeatWaveClusterMemoryEstimate").serviceDetails("DbSystem", "GetHeatWaveClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveClusterMemoryEstimate/GetHeatWaveClusterMemoryEstimate").method(Method.GET).requestBuilder(GetHeatWaveClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveClusterMemoryEstimate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(HeatWaveClusterMemoryEstimate.class, GetHeatWaveClusterMemoryEstimateResponse.Builder::heatWaveClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GetHeatWaveClusterMemoryEstimateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDbSystemsResponse listDbSystems(ListDbSystemsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDbSystemsResponse)this.clientCall(request, ListDbSystemsResponse::builder).logger(LOG, "listDbSystems").serviceDetails("DbSystem", "ListDbSystems", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystemSummary/ListDbSystems").method(Method.GET).requestBuilder(ListDbSystemsRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendQueryParam("isHeatWaveClusterAttached", (Object)request.getIsHeatWaveClusterAttached()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("isUpToDate", (Object)request.getIsUpToDate()).appendListQueryParam("databaseManagement", request.getDatabaseManagement(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(DbSystemSummary.class, ListDbSystemsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDbSystemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbSystemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RestartDbSystemResponse restartDbSystem(RestartDbSystemRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestartDbSystemDetails(), "restartDbSystemDetails is required");
        return (RestartDbSystemResponse)this.clientCall(request, RestartDbSystemResponse::builder).logger(LOG, "restartDbSystem").serviceDetails("DbSystem", "RestartDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/RestartDbSystem").method(Method.POST).requestBuilder(RestartDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", RestartDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartDbSystemResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RestartHeatWaveClusterResponse restartHeatWaveCluster(RestartHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (RestartHeatWaveClusterResponse)this.clientCall(request, RestartHeatWaveClusterResponse::builder).logger(LOG, "restartHeatWaveCluster").serviceDetails("DbSystem", "RestartHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/RestartHeatWaveCluster").method(Method.POST).requestBuilder(RestartHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", RestartHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartHeatWaveClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartDbSystemResponse startDbSystem(StartDbSystemRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (StartDbSystemResponse)this.clientCall(request, StartDbSystemResponse::builder).logger(LOG, "startDbSystem").serviceDetails("DbSystem", "StartDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/StartDbSystem").method(Method.POST).requestBuilder(StartDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDbSystemResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartHeatWaveClusterResponse startHeatWaveCluster(StartHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (StartHeatWaveClusterResponse)this.clientCall(request, StartHeatWaveClusterResponse::builder).logger(LOG, "startHeatWaveCluster").serviceDetails("DbSystem", "StartHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/StartHeatWaveCluster").method(Method.POST).requestBuilder(StartHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartHeatWaveClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopDbSystemResponse stopDbSystem(StopDbSystemRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStopDbSystemDetails(), "stopDbSystemDetails is required");
        return (StopDbSystemResponse)this.clientCall(request, StopDbSystemResponse::builder).logger(LOG, "stopDbSystem").serviceDetails("DbSystem", "StopDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/StopDbSystem").method(Method.POST).requestBuilder(StopDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", StopDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDbSystemResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopHeatWaveClusterResponse stopHeatWaveCluster(StopHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return (StopHeatWaveClusterResponse)this.clientCall(request, StopHeatWaveClusterResponse::builder).logger(LOG, "stopHeatWaveCluster").serviceDetails("DbSystem", "StopHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/StopHeatWaveCluster").method(Method.POST).requestBuilder(StopHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StopHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopHeatWaveClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateDbSystemResponse updateDbSystem(UpdateDbSystemRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbSystemDetails(), "updateDbSystemDetails is required");
        return (UpdateDbSystemResponse)this.clientCall(request, UpdateDbSystemResponse::builder).logger(LOG, "updateDbSystem").serviceDetails("DbSystem", "UpdateDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/UpdateDbSystem").method(Method.PUT).requestBuilder(UpdateDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDbSystemResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateHeatWaveClusterResponse updateHeatWaveCluster(UpdateHeatWaveClusterRequest request) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHeatWaveClusterDetails(), "updateHeatWaveClusterDetails is required");
        return (UpdateHeatWaveClusterResponse)this.clientCall(request, UpdateHeatWaveClusterResponse::builder).logger(LOG, "updateHeatWaveCluster").serviceDetails("DbSystem", "UpdateHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/UpdateHeatWaveCluster").method(Method.PUT).requestBuilder(UpdateHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateHeatWaveClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DbSystemWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DbSystemPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DbSystemClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbSystemClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbSystemClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbSystemClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbSystemClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbSystemClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbSystemClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbSystemClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DbSystemClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbSystemClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbSystemClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "mysql";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"mysql");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DbSystemClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbSystemClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

