/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.DbSystem;
import com.oracle.bmc.mysql.model.DbSystemSummary;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DbSystemPaginators {
    private final DbSystem client;

    public DbSystemPaginators(DbSystem client) {
        this.client = client;
    }

    public Iterable<ListDbSystemsResponse> listDbSystemsResponseIterator(final ListDbSystemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDbSystemsRequest.Builder>(){

            @Override
            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, String>(){

            @Override
            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            @Override
            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            @Override
            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return DbSystemPaginators.this.client.listDbSystems(request);
            }
        });
    }

    public Iterable<DbSystemSummary> listDbSystemsRecordIterator(final ListDbSystemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDbSystemsRequest.Builder>(){

            @Override
            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, String>(){

            @Override
            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            @Override
            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDbSystemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            @Override
            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return DbSystemPaginators.this.client.listDbSystems(request);
            }
        }, (Function)new Function<ListDbSystemsResponse, List<DbSystemSummary>>(){

            @Override
            public List<DbSystemSummary> apply(ListDbSystemsResponse response) {
                return response.getItems();
            }
        });
    }
}

