/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.DbSystem;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.mysql.model.HeatWaveCluster;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DbSystemWaiters {
    private final ExecutorService executorService;
    private final DbSystem client;

    public DbSystemWaiters(ExecutorService executorService, DbSystem client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(BmcGenericWaiter waiter, GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        final HashSet<DbSystem.LifecycleState> targetStatesSet = new HashSet<DbSystem.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDbSystemRequest, GetDbSystemResponse>(){

            @Override
            public GetDbSystemResponse apply(GetDbSystemRequest request) {
                return DbSystemWaiters.this.client.getDbSystem(request);
            }
        }, (Predicate)new Predicate<GetDbSystemResponse>(){

            @Override
            public boolean test(GetDbSystemResponse response) {
                return targetStatesSet.contains((Object)response.getDbSystem().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbSystem.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> forHeatWaveCluster(GetHeatWaveClusterRequest request, HeatWaveCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHeatWaveCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> forHeatWaveCluster(GetHeatWaveClusterRequest request, HeatWaveCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHeatWaveCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> forHeatWaveCluster(GetHeatWaveClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, HeatWaveCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forHeatWaveCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> forHeatWaveCluster(BmcGenericWaiter waiter, GetHeatWaveClusterRequest request, HeatWaveCluster.LifecycleState ... targetStates) {
        final HashSet<HeatWaveCluster.LifecycleState> targetStatesSet = new HashSet<HeatWaveCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse>(){

            @Override
            public GetHeatWaveClusterResponse apply(GetHeatWaveClusterRequest request) {
                return DbSystemWaiters.this.client.getHeatWaveCluster(request);
            }
        }, (Predicate)new Predicate<GetHeatWaveClusterResponse>(){

            @Override
            public boolean test(GetHeatWaveClusterResponse response) {
                return targetStatesSet.contains((Object)response.getHeatWaveCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)HeatWaveCluster.LifecycleState.Deleted)), (Object)request);
    }
}

