/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.mysql.ReplicasAsync;
import com.oracle.bmc.mysql.model.Replica;
import com.oracle.bmc.mysql.model.ReplicaSummary;
import com.oracle.bmc.mysql.requests.CreateReplicaRequest;
import com.oracle.bmc.mysql.requests.DeleteReplicaRequest;
import com.oracle.bmc.mysql.requests.GetReplicaRequest;
import com.oracle.bmc.mysql.requests.ListReplicasRequest;
import com.oracle.bmc.mysql.requests.UpdateReplicaRequest;
import com.oracle.bmc.mysql.responses.CreateReplicaResponse;
import com.oracle.bmc.mysql.responses.DeleteReplicaResponse;
import com.oracle.bmc.mysql.responses.GetReplicaResponse;
import com.oracle.bmc.mysql.responses.ListReplicasResponse;
import com.oracle.bmc.mysql.responses.UpdateReplicaResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicasAsyncClient
extends BaseAsyncClient
implements ReplicasAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REPLICAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ReplicasAsyncClient.class);

    ReplicasAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateReplicaResponse> createReplica(CreateReplicaRequest request, AsyncHandler<CreateReplicaRequest, CreateReplicaResponse> handler) {
        Objects.requireNonNull(request.getCreateReplicaDetails(), "createReplicaDetails is required");
        return this.clientCall(request, CreateReplicaResponse::builder).logger(LOG, "createReplica").serviceDetails("Replicas", "CreateReplica", "").method(Method.POST).requestBuilder(CreateReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Replica.class, CreateReplicaResponse.Builder::replica).handleResponseHeaderString("location", CreateReplicaResponse.Builder::location).handleResponseHeaderString("etag", CreateReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateReplicaResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteReplicaResponse> deleteReplica(DeleteReplicaRequest request, AsyncHandler<DeleteReplicaRequest, DeleteReplicaResponse> handler) {
        Validate.notBlank((String)request.getReplicaId(), (String)"replicaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteReplicaResponse::builder).logger(LOG, "deleteReplica").serviceDetails("Replicas", "DeleteReplica", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Replica/DeleteReplica").method(Method.DELETE).requestBuilder(DeleteReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").appendPathParam(request.getReplicaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteReplicaResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetReplicaResponse> getReplica(GetReplicaRequest request, AsyncHandler<GetReplicaRequest, GetReplicaResponse> handler) {
        Validate.notBlank((String)request.getReplicaId(), (String)"replicaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetReplicaResponse::builder).logger(LOG, "getReplica").serviceDetails("Replicas", "GetReplica", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Replica/GetReplica").method(Method.GET).requestBuilder(GetReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").appendPathParam(request.getReplicaId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(Replica.class, GetReplicaResponse.Builder::replica).handleResponseHeaderString("etag", GetReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReplicaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListReplicasResponse> listReplicas(ListReplicasRequest request, AsyncHandler<ListReplicasRequest, ListReplicasResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListReplicasResponse::builder).logger(LOG, "listReplicas").serviceDetails("Replicas", "ListReplicas", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/ReplicaSummary/ListReplicas").method(Method.GET).requestBuilder(ListReplicasRequest::builder).basePath("/20190415").appendPathParam("replicas").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("replicaId", (Object)request.getReplicaId()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("isUpToDate", (Object)request.getIsUpToDate()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ReplicaSummary.class, ListReplicasResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListReplicasResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReplicasResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateReplicaResponse> updateReplica(UpdateReplicaRequest request, AsyncHandler<UpdateReplicaRequest, UpdateReplicaResponse> handler) {
        Validate.notBlank((String)request.getReplicaId(), (String)"replicaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateReplicaDetails(), "updateReplicaDetails is required");
        return this.clientCall(request, UpdateReplicaResponse::builder).logger(LOG, "updateReplica").serviceDetails("Replicas", "UpdateReplica", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Replica/UpdateReplica").method(Method.PUT).requestBuilder(UpdateReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").appendPathParam(request.getReplicaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateReplicaResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public ReplicasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ReplicasAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReplicasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ReplicasAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReplicasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ReplicasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ReplicasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ReplicasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ReplicasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ReplicasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ReplicasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ReplicasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ReplicasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ReplicasAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ReplicasAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "mysql";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"mysql");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ReplicasAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ReplicasAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

