/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.mysql.Replicas;
import com.oracle.bmc.mysql.ReplicasPaginators;
import com.oracle.bmc.mysql.ReplicasWaiters;
import com.oracle.bmc.mysql.model.Replica;
import com.oracle.bmc.mysql.model.ReplicaSummary;
import com.oracle.bmc.mysql.requests.CreateReplicaRequest;
import com.oracle.bmc.mysql.requests.DeleteReplicaRequest;
import com.oracle.bmc.mysql.requests.GetReplicaRequest;
import com.oracle.bmc.mysql.requests.ListReplicasRequest;
import com.oracle.bmc.mysql.requests.UpdateReplicaRequest;
import com.oracle.bmc.mysql.responses.CreateReplicaResponse;
import com.oracle.bmc.mysql.responses.DeleteReplicaResponse;
import com.oracle.bmc.mysql.responses.GetReplicaResponse;
import com.oracle.bmc.mysql.responses.ListReplicasResponse;
import com.oracle.bmc.mysql.responses.UpdateReplicaResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicasClient
extends BaseSyncClient
implements Replicas {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REPLICAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ReplicasClient.class);
    private final ReplicasWaiters waiters;
    private final ReplicasPaginators paginators;

    ReplicasClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Replicas-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ReplicasWaiters(executorService, this);
        this.paginators = new ReplicasPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateReplicaResponse createReplica(CreateReplicaRequest request) {
        Objects.requireNonNull(request.getCreateReplicaDetails(), "createReplicaDetails is required");
        return (CreateReplicaResponse)this.clientCall(request, CreateReplicaResponse::builder).logger(LOG, "createReplica").serviceDetails("Replicas", "CreateReplica", "").method(Method.POST).requestBuilder(CreateReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Replica.class, CreateReplicaResponse.Builder::replica).handleResponseHeaderString("location", CreateReplicaResponse.Builder::location).handleResponseHeaderString("etag", CreateReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateReplicaResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteReplicaResponse deleteReplica(DeleteReplicaRequest request) {
        Validate.notBlank((String)request.getReplicaId(), (String)"replicaId must not be blank", (Object[])new Object[0]);
        return (DeleteReplicaResponse)this.clientCall(request, DeleteReplicaResponse::builder).logger(LOG, "deleteReplica").serviceDetails("Replicas", "DeleteReplica", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Replica/DeleteReplica").method(Method.DELETE).requestBuilder(DeleteReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").appendPathParam(request.getReplicaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteReplicaResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetReplicaResponse getReplica(GetReplicaRequest request) {
        Validate.notBlank((String)request.getReplicaId(), (String)"replicaId must not be blank", (Object[])new Object[0]);
        return (GetReplicaResponse)this.clientCall(request, GetReplicaResponse::builder).logger(LOG, "getReplica").serviceDetails("Replicas", "GetReplica", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Replica/GetReplica").method(Method.GET).requestBuilder(GetReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").appendPathParam(request.getReplicaId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).operationUsesDefaultRetries().handleBody(Replica.class, GetReplicaResponse.Builder::replica).handleResponseHeaderString("etag", GetReplicaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReplicaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListReplicasResponse listReplicas(ListReplicasRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListReplicasResponse)this.clientCall(request, ListReplicasResponse::builder).logger(LOG, "listReplicas").serviceDetails("Replicas", "ListReplicas", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/ReplicaSummary/ListReplicas").method(Method.GET).requestBuilder(ListReplicasRequest::builder).basePath("/20190415").appendPathParam("replicas").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("replicaId", (Object)request.getReplicaId()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("isUpToDate", (Object)request.getIsUpToDate()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(ReplicaSummary.class, ListReplicasResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListReplicasResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListReplicasResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateReplicaResponse updateReplica(UpdateReplicaRequest request) {
        Validate.notBlank((String)request.getReplicaId(), (String)"replicaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateReplicaDetails(), "updateReplicaDetails is required");
        return (UpdateReplicaResponse)this.clientCall(request, UpdateReplicaResponse::builder).logger(LOG, "updateReplica").serviceDetails("Replicas", "UpdateReplica", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/Replica/UpdateReplica").method(Method.PUT).requestBuilder(UpdateReplicaRequest::builder).basePath("/20190415").appendPathParam("replicas").appendPathParam(request.getReplicaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateReplicaResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ReplicasWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ReplicasPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ReplicasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ReplicasClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ReplicasClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ReplicasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ReplicasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ReplicasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ReplicasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ReplicasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ReplicasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ReplicasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ReplicasClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "mysql";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"mysql");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ReplicasClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ReplicasClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

