/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.mysql.model.CopyPolicy;
import com.oracle.bmc.mysql.model.PitrPolicy;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackupPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="copyPolicies")
    private final List<CopyPolicy> copyPolicies;
    @JsonProperty(value="windowStartTime")
    private final String windowStartTime;
    @JsonProperty(value="retentionInDays")
    private final Integer retentionInDays;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="pitrPolicy")
    private final PitrPolicy pitrPolicy;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "copyPolicies", "windowStartTime", "retentionInDays", "freeformTags", "definedTags", "pitrPolicy"})
    public BackupPolicy(Boolean isEnabled, List<CopyPolicy> copyPolicies, String windowStartTime, Integer retentionInDays, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, PitrPolicy pitrPolicy) {
        this.isEnabled = isEnabled;
        this.copyPolicies = copyPolicies;
        this.windowStartTime = windowStartTime;
        this.retentionInDays = retentionInDays;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.pitrPolicy = pitrPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public List<CopyPolicy> getCopyPolicies() {
        return this.copyPolicies;
    }

    public String getWindowStartTime() {
        return this.windowStartTime;
    }

    public Integer getRetentionInDays() {
        return this.retentionInDays;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public PitrPolicy getPitrPolicy() {
        return this.pitrPolicy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackupPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", copyPolicies=").append(String.valueOf(this.copyPolicies));
        sb.append(", windowStartTime=").append(String.valueOf(this.windowStartTime));
        sb.append(", retentionInDays=").append(String.valueOf(this.retentionInDays));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", pitrPolicy=").append(String.valueOf((Object)this.pitrPolicy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupPolicy)) {
            return false;
        }
        BackupPolicy other = (BackupPolicy)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.copyPolicies, other.copyPolicies) && Objects.equals(this.windowStartTime, other.windowStartTime) && Objects.equals(this.retentionInDays, other.retentionInDays) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.pitrPolicy, (Object)other.pitrPolicy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.copyPolicies == null ? 43 : this.copyPolicies.hashCode());
        result = result * 59 + (this.windowStartTime == null ? 43 : this.windowStartTime.hashCode());
        result = result * 59 + (this.retentionInDays == null ? 43 : this.retentionInDays.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.pitrPolicy == null ? 43 : this.pitrPolicy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="copyPolicies")
        private List<CopyPolicy> copyPolicies;
        @JsonProperty(value="windowStartTime")
        private String windowStartTime;
        @JsonProperty(value="retentionInDays")
        private Integer retentionInDays;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="pitrPolicy")
        private PitrPolicy pitrPolicy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder copyPolicies(List<CopyPolicy> copyPolicies) {
            this.copyPolicies = copyPolicies;
            this.__explicitlySet__.add("copyPolicies");
            return this;
        }

        public Builder windowStartTime(String windowStartTime) {
            this.windowStartTime = windowStartTime;
            this.__explicitlySet__.add("windowStartTime");
            return this;
        }

        public Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            this.__explicitlySet__.add("retentionInDays");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder pitrPolicy(PitrPolicy pitrPolicy) {
            this.pitrPolicy = pitrPolicy;
            this.__explicitlySet__.add("pitrPolicy");
            return this;
        }

        public BackupPolicy build() {
            BackupPolicy model = new BackupPolicy(this.isEnabled, this.copyPolicies, this.windowStartTime, this.retentionInDays, this.freeformTags, this.definedTags, this.pitrPolicy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackupPolicy model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("copyPolicies")) {
                this.copyPolicies(model.getCopyPolicies());
            }
            if (model.wasPropertyExplicitlySet("windowStartTime")) {
                this.windowStartTime(model.getWindowStartTime());
            }
            if (model.wasPropertyExplicitlySet("retentionInDays")) {
                this.retentionInDays(model.getRetentionInDays());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("pitrPolicy")) {
                this.pitrPolicy(model.getPitrPolicy());
            }
            return this;
        }
    }
}

