/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.mysql.model.AnonymousTransactionsHandling;
import com.oracle.bmc.mysql.model.CaCertificate;
import com.oracle.bmc.mysql.model.ChannelSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ChannelSourceMysql
extends ChannelSource {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="sslMode")
    private final SslMode sslMode;
    @JsonProperty(value="sslCaCertificate")
    private final CaCertificate sslCaCertificate;
    @JsonProperty(value="anonymousTransactionsHandling")
    private final AnonymousTransactionsHandling anonymousTransactionsHandling;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ChannelSourceMysql(String hostname, Integer port, String username, SslMode sslMode, CaCertificate sslCaCertificate, AnonymousTransactionsHandling anonymousTransactionsHandling) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.sslMode = sslMode;
        this.sslCaCertificate = sslCaCertificate;
        this.anonymousTransactionsHandling = anonymousTransactionsHandling;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public CaCertificate getSslCaCertificate() {
        return this.sslCaCertificate;
    }

    public AnonymousTransactionsHandling getAnonymousTransactionsHandling() {
        return this.anonymousTransactionsHandling;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChannelSourceMysql(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", sslMode=").append(String.valueOf((Object)this.sslMode));
        sb.append(", sslCaCertificate=").append(String.valueOf((Object)this.sslCaCertificate));
        sb.append(", anonymousTransactionsHandling=").append(String.valueOf((Object)this.anonymousTransactionsHandling));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelSourceMysql)) {
            return false;
        }
        ChannelSourceMysql other = (ChannelSourceMysql)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals(this.port, other.port) && Objects.equals(this.username, other.username) && Objects.equals((Object)this.sslMode, (Object)other.sslMode) && Objects.equals((Object)this.sslCaCertificate, (Object)other.sslCaCertificate) && Objects.equals((Object)this.anonymousTransactionsHandling, (Object)other.anonymousTransactionsHandling) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.sslMode == null ? 43 : this.sslMode.hashCode());
        result = result * 59 + (this.sslCaCertificate == null ? 43 : this.sslCaCertificate.hashCode());
        result = result * 59 + (this.anonymousTransactionsHandling == null ? 43 : this.anonymousTransactionsHandling.hashCode());
        return result;
    }

    public static enum SslMode implements BmcEnum
    {
        VerifyIdentity("VERIFY_IDENTITY"),
        VerifyCa("VERIFY_CA"),
        Required("REQUIRED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SslMode> map;

        private SslMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SslMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SslMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SslMode.class);
            map = new HashMap<String, SslMode>();
            for (SslMode v : SslMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="sslMode")
        private SslMode sslMode;
        @JsonProperty(value="sslCaCertificate")
        private CaCertificate sslCaCertificate;
        @JsonProperty(value="anonymousTransactionsHandling")
        private AnonymousTransactionsHandling anonymousTransactionsHandling;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = sslMode;
            this.__explicitlySet__.add("sslMode");
            return this;
        }

        public Builder sslCaCertificate(CaCertificate sslCaCertificate) {
            this.sslCaCertificate = sslCaCertificate;
            this.__explicitlySet__.add("sslCaCertificate");
            return this;
        }

        public Builder anonymousTransactionsHandling(AnonymousTransactionsHandling anonymousTransactionsHandling) {
            this.anonymousTransactionsHandling = anonymousTransactionsHandling;
            this.__explicitlySet__.add("anonymousTransactionsHandling");
            return this;
        }

        public ChannelSourceMysql build() {
            ChannelSourceMysql model = new ChannelSourceMysql(this.hostname, this.port, this.username, this.sslMode, this.sslCaCertificate, this.anonymousTransactionsHandling);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChannelSourceMysql model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("sslMode")) {
                this.sslMode(model.getSslMode());
            }
            if (model.wasPropertyExplicitlySet("sslCaCertificate")) {
                this.sslCaCertificate(model.getSslCaCertificate());
            }
            if (model.wasPropertyExplicitlySet("anonymousTransactionsHandling")) {
                this.anonymousTransactionsHandling(model.getAnonymousTransactionsHandling());
            }
            return this;
        }
    }
}

