/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CopyBackupDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="backupCopyRetentionInDays")
    private final Integer backupCopyRetentionInDays;
    @JsonProperty(value="sourceBackupId")
    private final String sourceBackupId;
    @JsonProperty(value="sourceRegion")
    private final String sourceRegion;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "description", "displayName", "backupCopyRetentionInDays", "sourceBackupId", "sourceRegion"})
    public CopyBackupDetails(String compartmentId, String description, String displayName, Integer backupCopyRetentionInDays, String sourceBackupId, String sourceRegion) {
        this.compartmentId = compartmentId;
        this.description = description;
        this.displayName = displayName;
        this.backupCopyRetentionInDays = backupCopyRetentionInDays;
        this.sourceBackupId = sourceBackupId;
        this.sourceRegion = sourceRegion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getBackupCopyRetentionInDays() {
        return this.backupCopyRetentionInDays;
    }

    public String getSourceBackupId() {
        return this.sourceBackupId;
    }

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CopyBackupDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", backupCopyRetentionInDays=").append(String.valueOf(this.backupCopyRetentionInDays));
        sb.append(", sourceBackupId=").append(String.valueOf(this.sourceBackupId));
        sb.append(", sourceRegion=").append(String.valueOf(this.sourceRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyBackupDetails)) {
            return false;
        }
        CopyBackupDetails other = (CopyBackupDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.backupCopyRetentionInDays, other.backupCopyRetentionInDays) && Objects.equals(this.sourceBackupId, other.sourceBackupId) && Objects.equals(this.sourceRegion, other.sourceRegion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.backupCopyRetentionInDays == null ? 43 : this.backupCopyRetentionInDays.hashCode());
        result = result * 59 + (this.sourceBackupId == null ? 43 : this.sourceBackupId.hashCode());
        result = result * 59 + (this.sourceRegion == null ? 43 : this.sourceRegion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="backupCopyRetentionInDays")
        private Integer backupCopyRetentionInDays;
        @JsonProperty(value="sourceBackupId")
        private String sourceBackupId;
        @JsonProperty(value="sourceRegion")
        private String sourceRegion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder backupCopyRetentionInDays(Integer backupCopyRetentionInDays) {
            this.backupCopyRetentionInDays = backupCopyRetentionInDays;
            this.__explicitlySet__.add("backupCopyRetentionInDays");
            return this;
        }

        public Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            this.__explicitlySet__.add("sourceBackupId");
            return this;
        }

        public Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            this.__explicitlySet__.add("sourceRegion");
            return this;
        }

        public CopyBackupDetails build() {
            CopyBackupDetails model = new CopyBackupDetails(this.compartmentId, this.description, this.displayName, this.backupCopyRetentionInDays, this.sourceBackupId, this.sourceRegion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CopyBackupDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("backupCopyRetentionInDays")) {
                this.backupCopyRetentionInDays(model.getBackupCopyRetentionInDays());
            }
            if (model.wasPropertyExplicitlySet("sourceBackupId")) {
                this.sourceBackupId(model.getSourceBackupId());
            }
            if (model.wasPropertyExplicitlySet("sourceRegion")) {
                this.sourceRegion(model.getSourceRegion());
            }
            return this;
        }
    }
}

