/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.mysql.model.BackupPolicy;
import com.oracle.bmc.mysql.model.CrashRecoveryStatus;
import com.oracle.bmc.mysql.model.DatabaseManagementStatus;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.mysql.model.DbSystemEndpoint;
import com.oracle.bmc.mysql.model.DbSystemPlacement;
import com.oracle.bmc.mysql.model.DeletionPolicyDetails;
import com.oracle.bmc.mysql.model.HeatWaveClusterSummary;
import com.oracle.bmc.mysql.model.ReadEndpointDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="isHighlyAvailable")
    private final Boolean isHighlyAvailable;
    @JsonProperty(value="currentPlacement")
    private final DbSystemPlacement currentPlacement;
    @JsonProperty(value="isHeatWaveClusterAttached")
    private final Boolean isHeatWaveClusterAttached;
    @JsonProperty(value="heatWaveCluster")
    private final HeatWaveClusterSummary heatWaveCluster;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="endpoints")
    private final List<DbSystemEndpoint> endpoints;
    @JsonProperty(value="lifecycleState")
    private final DbSystem.LifecycleState lifecycleState;
    @JsonProperty(value="mysqlVersion")
    private final String mysqlVersion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="deletionPolicy")
    private final DeletionPolicyDetails deletionPolicy;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="backupPolicy")
    private final BackupPolicy backupPolicy;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="crashRecovery")
    private final CrashRecoveryStatus crashRecovery;
    @JsonProperty(value="databaseManagement")
    private final DatabaseManagementStatus databaseManagement;
    @JsonProperty(value="databaseMode")
    private final DbSystem.DatabaseMode databaseMode;
    @JsonProperty(value="accessMode")
    private final DbSystem.AccessMode accessMode;
    @JsonProperty(value="readEndpoint")
    private final ReadEndpointDetails readEndpoint;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "isHighlyAvailable", "currentPlacement", "isHeatWaveClusterAttached", "heatWaveCluster", "availabilityDomain", "faultDomain", "endpoints", "lifecycleState", "mysqlVersion", "timeCreated", "timeUpdated", "deletionPolicy", "freeformTags", "definedTags", "systemTags", "backupPolicy", "shapeName", "crashRecovery", "databaseManagement", "databaseMode", "accessMode", "readEndpoint"})
    public DbSystemSummary(String id, String displayName, String description, String compartmentId, Boolean isHighlyAvailable, DbSystemPlacement currentPlacement, Boolean isHeatWaveClusterAttached, HeatWaveClusterSummary heatWaveCluster, String availabilityDomain, String faultDomain, List<DbSystemEndpoint> endpoints, DbSystem.LifecycleState lifecycleState, String mysqlVersion, Date timeCreated, Date timeUpdated, DeletionPolicyDetails deletionPolicy, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, BackupPolicy backupPolicy, String shapeName, CrashRecoveryStatus crashRecovery, DatabaseManagementStatus databaseManagement, DbSystem.DatabaseMode databaseMode, DbSystem.AccessMode accessMode, ReadEndpointDetails readEndpoint) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.isHighlyAvailable = isHighlyAvailable;
        this.currentPlacement = currentPlacement;
        this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
        this.heatWaveCluster = heatWaveCluster;
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.endpoints = endpoints;
        this.lifecycleState = lifecycleState;
        this.mysqlVersion = mysqlVersion;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.deletionPolicy = deletionPolicy;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.backupPolicy = backupPolicy;
        this.shapeName = shapeName;
        this.crashRecovery = crashRecovery;
        this.databaseManagement = databaseManagement;
        this.databaseMode = databaseMode;
        this.accessMode = accessMode;
        this.readEndpoint = readEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsHighlyAvailable() {
        return this.isHighlyAvailable;
    }

    public DbSystemPlacement getCurrentPlacement() {
        return this.currentPlacement;
    }

    public Boolean getIsHeatWaveClusterAttached() {
        return this.isHeatWaveClusterAttached;
    }

    public HeatWaveClusterSummary getHeatWaveCluster() {
        return this.heatWaveCluster;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public List<DbSystemEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public DbSystem.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getMysqlVersion() {
        return this.mysqlVersion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public DeletionPolicyDetails getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public CrashRecoveryStatus getCrashRecovery() {
        return this.crashRecovery;
    }

    public DatabaseManagementStatus getDatabaseManagement() {
        return this.databaseManagement;
    }

    public DbSystem.DatabaseMode getDatabaseMode() {
        return this.databaseMode;
    }

    public DbSystem.AccessMode getAccessMode() {
        return this.accessMode;
    }

    public ReadEndpointDetails getReadEndpoint() {
        return this.readEndpoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", isHighlyAvailable=").append(String.valueOf(this.isHighlyAvailable));
        sb.append(", currentPlacement=").append(String.valueOf((Object)this.currentPlacement));
        sb.append(", isHeatWaveClusterAttached=").append(String.valueOf(this.isHeatWaveClusterAttached));
        sb.append(", heatWaveCluster=").append(String.valueOf((Object)this.heatWaveCluster));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", endpoints=").append(String.valueOf(this.endpoints));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", mysqlVersion=").append(String.valueOf(this.mysqlVersion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", deletionPolicy=").append(String.valueOf((Object)this.deletionPolicy));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", backupPolicy=").append(String.valueOf((Object)this.backupPolicy));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", crashRecovery=").append(String.valueOf((Object)this.crashRecovery));
        sb.append(", databaseManagement=").append(String.valueOf((Object)this.databaseManagement));
        sb.append(", databaseMode=").append(String.valueOf((Object)this.databaseMode));
        sb.append(", accessMode=").append(String.valueOf((Object)this.accessMode));
        sb.append(", readEndpoint=").append(String.valueOf((Object)this.readEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemSummary)) {
            return false;
        }
        DbSystemSummary other = (DbSystemSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isHighlyAvailable, other.isHighlyAvailable) && Objects.equals((Object)this.currentPlacement, (Object)other.currentPlacement) && Objects.equals(this.isHeatWaveClusterAttached, other.isHeatWaveClusterAttached) && Objects.equals((Object)this.heatWaveCluster, (Object)other.heatWaveCluster) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.endpoints, other.endpoints) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.mysqlVersion, other.mysqlVersion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.deletionPolicy, (Object)other.deletionPolicy) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals((Object)this.backupPolicy, (Object)other.backupPolicy) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals((Object)this.crashRecovery, (Object)other.crashRecovery) && Objects.equals((Object)this.databaseManagement, (Object)other.databaseManagement) && Objects.equals((Object)this.databaseMode, (Object)other.databaseMode) && Objects.equals((Object)this.accessMode, (Object)other.accessMode) && Objects.equals((Object)this.readEndpoint, (Object)other.readEndpoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isHighlyAvailable == null ? 43 : this.isHighlyAvailable.hashCode());
        result = result * 59 + (this.currentPlacement == null ? 43 : this.currentPlacement.hashCode());
        result = result * 59 + (this.isHeatWaveClusterAttached == null ? 43 : this.isHeatWaveClusterAttached.hashCode());
        result = result * 59 + (this.heatWaveCluster == null ? 43 : this.heatWaveCluster.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.endpoints == null ? 43 : this.endpoints.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.mysqlVersion == null ? 43 : this.mysqlVersion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.deletionPolicy == null ? 43 : this.deletionPolicy.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.backupPolicy == null ? 43 : this.backupPolicy.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.crashRecovery == null ? 43 : this.crashRecovery.hashCode());
        result = result * 59 + (this.databaseManagement == null ? 43 : this.databaseManagement.hashCode());
        result = result * 59 + (this.databaseMode == null ? 43 : this.databaseMode.hashCode());
        result = result * 59 + (this.accessMode == null ? 43 : this.accessMode.hashCode());
        result = result * 59 + (this.readEndpoint == null ? 43 : this.readEndpoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="isHighlyAvailable")
        private Boolean isHighlyAvailable;
        @JsonProperty(value="currentPlacement")
        private DbSystemPlacement currentPlacement;
        @JsonProperty(value="isHeatWaveClusterAttached")
        private Boolean isHeatWaveClusterAttached;
        @JsonProperty(value="heatWaveCluster")
        private HeatWaveClusterSummary heatWaveCluster;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="endpoints")
        private List<DbSystemEndpoint> endpoints;
        @JsonProperty(value="lifecycleState")
        private DbSystem.LifecycleState lifecycleState;
        @JsonProperty(value="mysqlVersion")
        private String mysqlVersion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="deletionPolicy")
        private DeletionPolicyDetails deletionPolicy;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="backupPolicy")
        private BackupPolicy backupPolicy;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="crashRecovery")
        private CrashRecoveryStatus crashRecovery;
        @JsonProperty(value="databaseManagement")
        private DatabaseManagementStatus databaseManagement;
        @JsonProperty(value="databaseMode")
        private DbSystem.DatabaseMode databaseMode;
        @JsonProperty(value="accessMode")
        private DbSystem.AccessMode accessMode;
        @JsonProperty(value="readEndpoint")
        private ReadEndpointDetails readEndpoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder isHighlyAvailable(Boolean isHighlyAvailable) {
            this.isHighlyAvailable = isHighlyAvailable;
            this.__explicitlySet__.add("isHighlyAvailable");
            return this;
        }

        public Builder currentPlacement(DbSystemPlacement currentPlacement) {
            this.currentPlacement = currentPlacement;
            this.__explicitlySet__.add("currentPlacement");
            return this;
        }

        public Builder isHeatWaveClusterAttached(Boolean isHeatWaveClusterAttached) {
            this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
            this.__explicitlySet__.add("isHeatWaveClusterAttached");
            return this;
        }

        public Builder heatWaveCluster(HeatWaveClusterSummary heatWaveCluster) {
            this.heatWaveCluster = heatWaveCluster;
            this.__explicitlySet__.add("heatWaveCluster");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder endpoints(List<DbSystemEndpoint> endpoints) {
            this.endpoints = endpoints;
            this.__explicitlySet__.add("endpoints");
            return this;
        }

        public Builder lifecycleState(DbSystem.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder mysqlVersion(String mysqlVersion) {
            this.mysqlVersion = mysqlVersion;
            this.__explicitlySet__.add("mysqlVersion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder deletionPolicy(DeletionPolicyDetails deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
            this.__explicitlySet__.add("deletionPolicy");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy = backupPolicy;
            this.__explicitlySet__.add("backupPolicy");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder crashRecovery(CrashRecoveryStatus crashRecovery) {
            this.crashRecovery = crashRecovery;
            this.__explicitlySet__.add("crashRecovery");
            return this;
        }

        public Builder databaseManagement(DatabaseManagementStatus databaseManagement) {
            this.databaseManagement = databaseManagement;
            this.__explicitlySet__.add("databaseManagement");
            return this;
        }

        public Builder databaseMode(DbSystem.DatabaseMode databaseMode) {
            this.databaseMode = databaseMode;
            this.__explicitlySet__.add("databaseMode");
            return this;
        }

        public Builder accessMode(DbSystem.AccessMode accessMode) {
            this.accessMode = accessMode;
            this.__explicitlySet__.add("accessMode");
            return this;
        }

        public Builder readEndpoint(ReadEndpointDetails readEndpoint) {
            this.readEndpoint = readEndpoint;
            this.__explicitlySet__.add("readEndpoint");
            return this;
        }

        public DbSystemSummary build() {
            DbSystemSummary model = new DbSystemSummary(this.id, this.displayName, this.description, this.compartmentId, this.isHighlyAvailable, this.currentPlacement, this.isHeatWaveClusterAttached, this.heatWaveCluster, this.availabilityDomain, this.faultDomain, this.endpoints, this.lifecycleState, this.mysqlVersion, this.timeCreated, this.timeUpdated, this.deletionPolicy, this.freeformTags, this.definedTags, this.systemTags, this.backupPolicy, this.shapeName, this.crashRecovery, this.databaseManagement, this.databaseMode, this.accessMode, this.readEndpoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("isHighlyAvailable")) {
                this.isHighlyAvailable(model.getIsHighlyAvailable());
            }
            if (model.wasPropertyExplicitlySet("currentPlacement")) {
                this.currentPlacement(model.getCurrentPlacement());
            }
            if (model.wasPropertyExplicitlySet("isHeatWaveClusterAttached")) {
                this.isHeatWaveClusterAttached(model.getIsHeatWaveClusterAttached());
            }
            if (model.wasPropertyExplicitlySet("heatWaveCluster")) {
                this.heatWaveCluster(model.getHeatWaveCluster());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("endpoints")) {
                this.endpoints(model.getEndpoints());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("mysqlVersion")) {
                this.mysqlVersion(model.getMysqlVersion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("deletionPolicy")) {
                this.deletionPolicy(model.getDeletionPolicy());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("backupPolicy")) {
                this.backupPolicy(model.getBackupPolicy());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("crashRecovery")) {
                this.crashRecovery(model.getCrashRecovery());
            }
            if (model.wasPropertyExplicitlySet("databaseManagement")) {
                this.databaseManagement(model.getDatabaseManagement());
            }
            if (model.wasPropertyExplicitlySet("databaseMode")) {
                this.databaseMode(model.getDatabaseMode());
            }
            if (model.wasPropertyExplicitlySet("accessMode")) {
                this.accessMode(model.getAccessMode());
            }
            if (model.wasPropertyExplicitlySet("readEndpoint")) {
                this.readEndpoint(model.getReadEndpoint());
            }
            return this;
        }
    }
}

