/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListShapesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private List<IsSupportedFor> isSupportedFor;
    private String availabilityDomain;
    private String name;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<IsSupportedFor> getIsSupportedFor() {
        return this.isSupportedFor;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getName() {
        return this.name;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).isSupportedFor(this.isSupportedFor).availabilityDomain(this.availabilityDomain).name(this.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isSupportedFor=").append(String.valueOf(this.isSupportedFor));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListShapesRequest)) {
            return false;
        }
        ListShapesRequest other = (ListShapesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isSupportedFor, other.isSupportedFor) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isSupportedFor == null ? 43 : this.isSupportedFor.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListShapesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private List<IsSupportedFor> isSupportedFor = null;
        private String availabilityDomain = null;
        private String name = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isSupportedFor(List<IsSupportedFor> isSupportedFor) {
            this.isSupportedFor = isSupportedFor;
            return this;
        }

        public Builder isSupportedFor(IsSupportedFor singularValue) {
            return this.isSupportedFor(Arrays.asList(singularValue));
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListShapesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.isSupportedFor(o.getIsSupportedFor());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.name(o.getName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListShapesRequest build() {
            ListShapesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListShapesRequest buildWithoutInvocationCallback() {
            ListShapesRequest request = new ListShapesRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.isSupportedFor = this.isSupportedFor;
            request.availabilityDomain = this.availabilityDomain;
            request.name = this.name;
            return request;
        }
    }

    public static enum IsSupportedFor implements BmcEnum
    {
        Dbsystem("DBSYSTEM"),
        Heatwavecluster("HEATWAVECLUSTER");

        private final String value;
        private static Map<String, IsSupportedFor> map;

        private IsSupportedFor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSupportedFor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSupportedFor: " + key);
        }

        static {
            map = new HashMap<String, IsSupportedFor>();
            for (IsSupportedFor v : IsSupportedFor.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

