/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Column
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="isNullable")
    private final Boolean isNullable;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;
    @JsonProperty(value="isAsUuid")
    private final Boolean isAsUuid;
    @JsonProperty(value="isGenerated")
    private final Boolean isGenerated;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "isNullable", "defaultValue", "isAsUuid", "isGenerated"})
    public Column(String name, String type, Boolean isNullable, String defaultValue, Boolean isAsUuid, Boolean isGenerated) {
        this.name = name;
        this.type = type;
        this.isNullable = isNullable;
        this.defaultValue = defaultValue;
        this.isAsUuid = isAsUuid;
        this.isGenerated = isGenerated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getIsNullable() {
        return this.isNullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getIsAsUuid() {
        return this.isAsUuid;
    }

    public Boolean getIsGenerated() {
        return this.isGenerated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Column(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", isNullable=").append(String.valueOf(this.isNullable));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", isAsUuid=").append(String.valueOf(this.isAsUuid));
        sb.append(", isGenerated=").append(String.valueOf(this.isGenerated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.isNullable, other.isNullable) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.isAsUuid, other.isAsUuid) && Objects.equals(this.isGenerated, other.isGenerated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isNullable == null ? 43 : this.isNullable.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.isAsUuid == null ? 43 : this.isAsUuid.hashCode());
        result = result * 59 + (this.isGenerated == null ? 43 : this.isGenerated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="isNullable")
        private Boolean isNullable;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonProperty(value="isAsUuid")
        private Boolean isAsUuid;
        @JsonProperty(value="isGenerated")
        private Boolean isGenerated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            this.__explicitlySet__.add("isNullable");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder isAsUuid(Boolean isAsUuid) {
            this.isAsUuid = isAsUuid;
            this.__explicitlySet__.add("isAsUuid");
            return this;
        }

        public Builder isGenerated(Boolean isGenerated) {
            this.isGenerated = isGenerated;
            this.__explicitlySet__.add("isGenerated");
            return this;
        }

        public Column build() {
            Column model = new Column(this.name, this.type, this.isNullable, this.defaultValue, this.isAsUuid, this.isGenerated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Column model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isNullable")) {
                this.isNullable(model.getIsNullable());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("isAsUuid")) {
                this.isAsUuid(model.getIsAsUuid());
            }
            if (model.wasPropertyExplicitlySet("isGenerated")) {
                this.isGenerated(model.getIsGenerated());
            }
            return this;
        }
    }
}

