/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.nosql.model.RequestUsage;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Row
extends ExplicitlySetBmcModel {
    @JsonProperty(value="value")
    private final Map<String, Object> value;
    @JsonProperty(value="timeOfExpiration")
    private final Date timeOfExpiration;
    @JsonProperty(value="usage")
    private final RequestUsage usage;

    @Deprecated
    @ConstructorProperties(value={"value", "timeOfExpiration", "usage"})
    public Row(Map<String, Object> value, Date timeOfExpiration, RequestUsage usage) {
        this.value = value;
        this.timeOfExpiration = timeOfExpiration;
        this.usage = usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public Date getTimeOfExpiration() {
        return this.timeOfExpiration;
    }

    public RequestUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Row(");
        sb.append("super=").append(super.toString());
        sb.append("value=").append(String.valueOf(this.value));
        sb.append(", timeOfExpiration=").append(String.valueOf(this.timeOfExpiration));
        sb.append(", usage=").append(String.valueOf((Object)this.usage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)((Object)o);
        return Objects.equals(this.value, other.value) && Objects.equals(this.timeOfExpiration, other.timeOfExpiration) && Objects.equals((Object)this.usage, (Object)other.usage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.timeOfExpiration == null ? 43 : this.timeOfExpiration.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="value")
        private Map<String, Object> value;
        @JsonProperty(value="timeOfExpiration")
        private Date timeOfExpiration;
        @JsonProperty(value="usage")
        private RequestUsage usage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder value(Map<String, Object> value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder timeOfExpiration(Date timeOfExpiration) {
            this.timeOfExpiration = timeOfExpiration;
            this.__explicitlySet__.add("timeOfExpiration");
            return this;
        }

        public Builder usage(RequestUsage usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Row build() {
            Row model = new Row(this.value, this.timeOfExpiration, this.usage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Row model) {
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("timeOfExpiration")) {
                this.timeOfExpiration(model.getTimeOfExpiration());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            return this;
        }
    }
}

