/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StatementSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operation")
    private final Operation operation;
    @JsonProperty(value="tableName")
    private final String tableName;
    @JsonProperty(value="indexName")
    private final String indexName;
    @JsonProperty(value="isIfExists")
    private final Boolean isIfExists;
    @JsonProperty(value="isIfNotExists")
    private final Boolean isIfNotExists;
    @JsonProperty(value="syntaxError")
    private final String syntaxError;

    @Deprecated
    @ConstructorProperties(value={"operation", "tableName", "indexName", "isIfExists", "isIfNotExists", "syntaxError"})
    public StatementSummary(Operation operation, String tableName, String indexName, Boolean isIfExists, Boolean isIfNotExists, String syntaxError) {
        this.operation = operation;
        this.tableName = tableName;
        this.indexName = indexName;
        this.isIfExists = isIfExists;
        this.isIfNotExists = isIfNotExists;
        this.syntaxError = syntaxError;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Boolean getIsIfExists() {
        return this.isIfExists;
    }

    public Boolean getIsIfNotExists() {
        return this.isIfNotExists;
    }

    public String getSyntaxError() {
        return this.syntaxError;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StatementSummary(");
        sb.append("super=").append(super.toString());
        sb.append("operation=").append(String.valueOf((Object)this.operation));
        sb.append(", tableName=").append(String.valueOf(this.tableName));
        sb.append(", indexName=").append(String.valueOf(this.indexName));
        sb.append(", isIfExists=").append(String.valueOf(this.isIfExists));
        sb.append(", isIfNotExists=").append(String.valueOf(this.isIfNotExists));
        sb.append(", syntaxError=").append(String.valueOf(this.syntaxError));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatementSummary)) {
            return false;
        }
        StatementSummary other = (StatementSummary)((Object)o);
        return Objects.equals((Object)this.operation, (Object)other.operation) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.indexName, other.indexName) && Objects.equals(this.isIfExists, other.isIfExists) && Objects.equals(this.isIfNotExists, other.isIfNotExists) && Objects.equals(this.syntaxError, other.syntaxError) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.tableName == null ? 43 : this.tableName.hashCode());
        result = result * 59 + (this.indexName == null ? 43 : this.indexName.hashCode());
        result = result * 59 + (this.isIfExists == null ? 43 : this.isIfExists.hashCode());
        result = result * 59 + (this.isIfNotExists == null ? 43 : this.isIfNotExists.hashCode());
        result = result * 59 + (this.syntaxError == null ? 43 : this.syntaxError.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Operation implements BmcEnum
    {
        CreateTable("CREATE_TABLE"),
        AlterTable("ALTER_TABLE"),
        DropTable("DROP_TABLE"),
        CreateIndex("CREATE_INDEX"),
        DropIndex("DROP_INDEX"),
        Select("SELECT"),
        Update("UPDATE"),
        Insert("INSERT"),
        Delete("DELETE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Operation> map;

        private Operation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Operation', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Operation.class);
            map = new HashMap<String, Operation>();
            for (Operation v : Operation.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operation")
        private Operation operation;
        @JsonProperty(value="tableName")
        private String tableName;
        @JsonProperty(value="indexName")
        private String indexName;
        @JsonProperty(value="isIfExists")
        private Boolean isIfExists;
        @JsonProperty(value="isIfNotExists")
        private Boolean isIfNotExists;
        @JsonProperty(value="syntaxError")
        private String syntaxError;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operation(Operation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            this.__explicitlySet__.add("tableName");
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            this.__explicitlySet__.add("indexName");
            return this;
        }

        public Builder isIfExists(Boolean isIfExists) {
            this.isIfExists = isIfExists;
            this.__explicitlySet__.add("isIfExists");
            return this;
        }

        public Builder isIfNotExists(Boolean isIfNotExists) {
            this.isIfNotExists = isIfNotExists;
            this.__explicitlySet__.add("isIfNotExists");
            return this;
        }

        public Builder syntaxError(String syntaxError) {
            this.syntaxError = syntaxError;
            this.__explicitlySet__.add("syntaxError");
            return this;
        }

        public StatementSummary build() {
            StatementSummary model = new StatementSummary(this.operation, this.tableName, this.indexName, this.isIfExists, this.isIfNotExists, this.syntaxError);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StatementSummary model) {
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("tableName")) {
                this.tableName(model.getTableName());
            }
            if (model.wasPropertyExplicitlySet("indexName")) {
                this.indexName(model.getIndexName());
            }
            if (model.wasPropertyExplicitlySet("isIfExists")) {
                this.isIfExists(model.getIsIfExists());
            }
            if (model.wasPropertyExplicitlySet("isIfNotExists")) {
                this.isIfNotExists(model.getIsIfNotExists());
            }
            if (model.wasPropertyExplicitlySet("syntaxError")) {
                this.syntaxError(model.getSyntaxError());
            }
            return this;
        }
    }
}

