/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TableLimits
extends ExplicitlySetBmcModel {
    @JsonProperty(value="maxReadUnits")
    private final Integer maxReadUnits;
    @JsonProperty(value="maxWriteUnits")
    private final Integer maxWriteUnits;
    @JsonProperty(value="maxStorageInGBs")
    private final Integer maxStorageInGBs;
    @JsonProperty(value="capacityMode")
    private final CapacityMode capacityMode;

    @Deprecated
    @ConstructorProperties(value={"maxReadUnits", "maxWriteUnits", "maxStorageInGBs", "capacityMode"})
    public TableLimits(Integer maxReadUnits, Integer maxWriteUnits, Integer maxStorageInGBs, CapacityMode capacityMode) {
        this.maxReadUnits = maxReadUnits;
        this.maxWriteUnits = maxWriteUnits;
        this.maxStorageInGBs = maxStorageInGBs;
        this.capacityMode = capacityMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getMaxReadUnits() {
        return this.maxReadUnits;
    }

    public Integer getMaxWriteUnits() {
        return this.maxWriteUnits;
    }

    public Integer getMaxStorageInGBs() {
        return this.maxStorageInGBs;
    }

    public CapacityMode getCapacityMode() {
        return this.capacityMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TableLimits(");
        sb.append("super=").append(super.toString());
        sb.append("maxReadUnits=").append(String.valueOf(this.maxReadUnits));
        sb.append(", maxWriteUnits=").append(String.valueOf(this.maxWriteUnits));
        sb.append(", maxStorageInGBs=").append(String.valueOf(this.maxStorageInGBs));
        sb.append(", capacityMode=").append(String.valueOf((Object)this.capacityMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableLimits)) {
            return false;
        }
        TableLimits other = (TableLimits)((Object)o);
        return Objects.equals(this.maxReadUnits, other.maxReadUnits) && Objects.equals(this.maxWriteUnits, other.maxWriteUnits) && Objects.equals(this.maxStorageInGBs, other.maxStorageInGBs) && Objects.equals((Object)this.capacityMode, (Object)other.capacityMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.maxReadUnits == null ? 43 : this.maxReadUnits.hashCode());
        result = result * 59 + (this.maxWriteUnits == null ? 43 : this.maxWriteUnits.hashCode());
        result = result * 59 + (this.maxStorageInGBs == null ? 43 : this.maxStorageInGBs.hashCode());
        result = result * 59 + (this.capacityMode == null ? 43 : this.capacityMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CapacityMode implements BmcEnum
    {
        Provisioned("PROVISIONED"),
        OnDemand("ON_DEMAND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CapacityMode> map;

        private CapacityMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CapacityMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CapacityMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CapacityMode.class);
            map = new HashMap<String, CapacityMode>();
            for (CapacityMode v : CapacityMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maxReadUnits")
        private Integer maxReadUnits;
        @JsonProperty(value="maxWriteUnits")
        private Integer maxWriteUnits;
        @JsonProperty(value="maxStorageInGBs")
        private Integer maxStorageInGBs;
        @JsonProperty(value="capacityMode")
        private CapacityMode capacityMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maxReadUnits(Integer maxReadUnits) {
            this.maxReadUnits = maxReadUnits;
            this.__explicitlySet__.add("maxReadUnits");
            return this;
        }

        public Builder maxWriteUnits(Integer maxWriteUnits) {
            this.maxWriteUnits = maxWriteUnits;
            this.__explicitlySet__.add("maxWriteUnits");
            return this;
        }

        public Builder maxStorageInGBs(Integer maxStorageInGBs) {
            this.maxStorageInGBs = maxStorageInGBs;
            this.__explicitlySet__.add("maxStorageInGBs");
            return this;
        }

        public Builder capacityMode(CapacityMode capacityMode) {
            this.capacityMode = capacityMode;
            this.__explicitlySet__.add("capacityMode");
            return this;
        }

        public TableLimits build() {
            TableLimits model = new TableLimits(this.maxReadUnits, this.maxWriteUnits, this.maxStorageInGBs, this.capacityMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TableLimits model) {
            if (model.wasPropertyExplicitlySet("maxReadUnits")) {
                this.maxReadUnits(model.getMaxReadUnits());
            }
            if (model.wasPropertyExplicitlySet("maxWriteUnits")) {
                this.maxWriteUnits(model.getMaxWriteUnits());
            }
            if (model.wasPropertyExplicitlySet("maxStorageInGBs")) {
                this.maxStorageInGBs(model.getMaxStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("capacityMode")) {
                this.capacityMode(model.getCapacityMode());
            }
            return this;
        }
    }
}

